% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_config.R
\name{set_config}
\alias{set_config}
\title{Set a configuration parameter}
\usage{
set_config(...)
}
\arguments{
\item{...}{Parameters to set, they should be all named.}
}
\value{
Unlike \code{\link[pkgconfig:set_config]{pkgconfig::set_config()}}, invisibly returns the previous
values of all the parameters changed, similar to \code{\link[=options]{options()}}.
This allows previous values to be stored in a variable and restored later.
}
\description{
Set a configuration parameter, for the package we are calling from.
If called from the R prompt and not from a package, then it sets the
parameter for global environment.
}
\examples{
nom_adv(3)
default_adv <- set_config("nombre::thrice" = TRUE)
nom_adv(3)

nom_card(c(-1, 1e4))
default_card <- set_config("nombre::max_n" = 100, "nombre::negative" = "minus")
nom_card(c(-1, 1e4))

nom_denom(4)
default_denom <- set_config("nombre::quarter" = FALSE)
nom_denom(4)

set_config(default_adv, default_card, default_denom)
nom_adv(3)
nom_card(c(-1, 1e4))
nom_denom(4)
}
\seealso{
\code{\link[pkgconfig:get_config]{pkgconfig::get_config()}} and \code{\link[pkgconfig:set_config]{pkgconfig::set_config()}}
}
