% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distance_abundance.R
\name{plot_distance_abundance}
\alias{plot_distance_abundance}
\title{Plot the distance}
\usage{
plot_distance_abundance(
  abn.matrix,
  dist.matrix,
  sample.names = paste("Sample", 1:ncol(abn.matrix)),
  distance.name = "Pearson correlation",
  log.transform = TRUE,
  min.y = NULL,
  max.y = NULL,
  smooth.span = 0.1,
  only.boxplot = FALSE,
  binsize = 0.5,
  last.together = 30,
  show.counts = TRUE,
  add.threshold = NULL,
  file.name = NULL
)
}
\arguments{
\item{abn.matrix, dist.matrix}{abundance and distance matrix,
as calculated by calculate_distance_matrices()}

\item{sample.names}{names for the plots, enumerates the samples by default}

\item{distance.name}{distance metric used (for the y-axis title)}

\item{log.transform}{should the count matrix be log-transformed? If not, boxplot is skipped}

\item{min.y, max.y}{limits for the y axis. If unset default to symmetric including all values
in dist.matrix; min is set to 0 if there are no negative values}

\item{smooth.span}{span to be used for smoothing in the line plot; defaults to 0.1}

\item{only.boxplot}{option to skip the line plot (usually a good idea if there are too many points
and lines are too erratic); sets log.transform to TRUE}

\item{binsize}{size of each bin in the boxplot; defaults to 0.5}

\item{last.together}{groups observations so the highest abundance bin has at least this many}

\item{show.counts}{whether to show how many observations are in each bin}

\item{add.threshold}{adds a horizontal line at this value}

\item{file.name}{name of pdf to output the plots (console by default)}
}
\value{
A list of all the plots (returned silently), which are also plotted to the console,
        or specified pdf file
}
\description{
Creates the abundance-distance line and box plots for each sample.
}
\examples{
plot_distance_abundance(
  abn.matrix=matrix(2^(10*seq(0,1,length.out=100))),
  dist.matrix=matrix(seq(0,1,length.out=100)+(runif(100)/5)))
}
