
##################################################################
# Functions for use in node-based analysis of clade distribution #
##################################################################


##############INTERNAL FUNCTIONS (NOT TO BE EXPORTED)###############



Node_comm <- function(nodiv_data, node)
# returns a samplelist of sites occupied by at least one member of the node
{
  # node : the internal (ape) number of the node
  if (node < Ntip(nodiv_data$phylo)) #if it is in fact a tip
    nodespecs = nodiv_data$species[node] else nodespecs <- Node_species(nodiv_data, node)
  
  nodecom <- subset(nodiv_data$hcom, nodiv_data$hcom$id %in% nodespecs)
  return(nodecom)
}

identify_node <- function(node, tree)
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be an object of type phylo or nodiv_data")

  if(!is.vector(node)) stop("node must be either numeric or character")
  if(length(node)>1) warning("node was had length > 1 - only the first element was used")
  
  node <- node[1]
  
  if(is.character(node))
  {
    if(is.null(tree$node.label))
      stop("node could not be matched, as the phylogeny does not have node labels")
    node <- match(node, tree$node.label)
    if(is.na(node))
      stop("the node could not be matched to the node labels")
  }
  
  if(!node %in% nodenumbers(tree))
    stop("Undefined node")

  node
}

############ EXPORTED FUNCTIONS #############################

## Functions relating trees and nodes
	 
# returns the internal node number of the basal node on the phylogeny
basal_node <- function(tree) 
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be an object of type phylo or nodiv_data")
  return(Ntip(tree) + 1)
}

# returns a vector with the internal numbers of all nodes on the tree
nodenumbers <- function(tree) 
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be of type phylo or nodiv_data")
  return(1:Nnode(tree) + Ntip(tree))
}

Descendants <- function(node, tree) 
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be an object of type phylo or nodiv_data")
  return(tree$edge[ tree$edge[,1] == node , 2])
}
  

Parent <- function(node, tree)
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be an object of type phylo or nodiv_data")  
  if (node == Ntip(tree) +1 )   # If the node is the basal node it does not have a parent node
    return (NA)
  return(tree$edge[ tree$edge[,2] == node , 1])
}

Sister <- function(node, tree) 
{
  if(inherits(tree, "nodiv_data"))
    tree <- tree$phylo
  if(!inherits(tree, "phylo"))
    stop("tree must be an object of type phylo or nodiv_data")
  if (node == Ntip(tree) +1 )   # If the node is the basal node it does not have a sister node
    return (NA)
  sisters = Descendants(Parent(node, tree), tree)
  return(sisters[! sisters == node])
}	



####### Functions summarizing nodiv_data on nodes


Node_size <- function(nodiv_data, node = NULL)
{
  .local <- function(nodiv_data, node)
  {
    node <- identify_node(node, nodiv_data)
    return(sum(nodiv_data$node_species[node - Nspecies(nodiv_data),]))
  }
  if(!inherits(nodiv_data, "nodiv_data"))
    stop("nodiv_data must be an object of type nodiv_data or nodiv_result")
  if(is.null(node))
    node <- nodenumbers(nodiv_data)
  if(length(node) == 1)
    return(.local(nodiv_data, node)) else
      return(sapply(node, function(nod) .local(nodiv_data, nod))) 
}


Node_species <- function(nodiv_data, node, names = TRUE)
{
  if(!inherits(nodiv_data, "nodiv_data"))
    if(!inherits(nodiv_data, "phylo"))
      stop("nodiv_data must be an object of type nodiv_data or phylo") else
        return(Node_spec(nodiv_data, node, names))
  
  node <- identify_node(node, nodiv_data)
  ret <- which(nodiv_data$node_species[node-Nspecies(nodiv_data),] > 0)
  if(names)
    ret <- nodiv_data$species[ret]
  return(ret)
}


Node_sites <- function(nodiv_data, node)
{
	if(!inherits(nodiv_data, "nodiv_data"))
    stop("nodiv_data must be an object of type nodiv_data or nodiv_result")
  node <- identify_node(node, nodiv_data)
	nodecom <- Node_comm(nodiv_data, node)
	return(unique(nodecom$plot))
}
	


Node_occupancy <- function(nodiv_data, node = NULL)
{
  .local <- function(nodiv_data, node)
  {
    node <- identify_node(node, nodiv_data)
    return(length(Node_sites(nodiv_data, node)))
  }
  if(!inherits(nodiv_data, "nodiv_data"))
    stop("nodiv_data must be an object of type nodiv_data or nodiv_result")
  if(is.null(node))
    node <- nodenumbers(nodiv_data)
  if(length(node) == 1)
    return(.local(nodiv_data, node)) else
      return(sapply(node, function(nod) .local(nodiv_data, nod))) 
}


	

