% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Options.R
\name{noctua_options}
\alias{noctua_options}
\title{A method to configure noctua backend options.}
\usage{
noctua_options(
  file_parser = c("data.table", "vroom"),
  bigint = NULL,
  binary = NULL,
  json = NULL,
  cache_size = 0,
  clear_cache = FALSE,
  retry = 5,
  retry_quiet = FALSE
)
}
\arguments{
\item{file_parser}{Method to read and write tables to Athena, currently defaults to \code{data.table}. The file_parser also
determines the data format returned for example \code{data.table} will return \code{data.table} and \code{vroom} will return \code{tibble}.}

\item{bigint}{The R type that 64-bit integer types should be mapped to. Default \code{NULL} won't make any changes that \code{dbConnect} has set.
Inbuilt bigint conversion types ["integer64", "integer", "numeric", "character"].}

\item{binary}{The R type that [binary/varbinary] types should be mapped to. Default \code{NULL} won't make any changes that \code{dbConnect} has set.
Inbuilt binary conversion types ["raw", "character"].}

\item{json}{Attempt to converts AWS Athena data types [arrays, json] using \code{jsonlite:parse_json}. 
Default \code{NULL} won't make any changes that \code{dbConnect} has set. Inbuilt json conversion types ["auto", "character"].
Custom Json parsers can be provide by using a function with data frame parameter.}

\item{cache_size}{Number of queries to be cached. Currently only support caching up to 100 distinct queries.}

\item{clear_cache}{Clears all previous cached query metadata}

\item{retry}{Maximum number of requests to attempt.}

\item{retry_quiet}{If \code{FALSE}, will print a message from retry displaying how long until the next request.}
}
\value{
\code{noctua_options()} returns \code{NULL}, invisibly.
}
\description{
\code{noctua_options()} provides a method to change the backend. This includes changing the file parser,
 whether \code{noctua} should cache query ids locally and number of retries on a failed api call.
}
\examples{
library(noctua)

# change file parser from default data.table to vroom
noctua_options("vroom")

# cache queries locally
noctua_options(cache_size = 5)
}
