% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_meta_data.R
\name{query_metadata}
\alias{query_metadata}
\title{Query CO-OPS API for Station Metadata}
\usage{
query_metadata(
  station_id = NULL,
  resource = NULL,
  type = NULL,
  ports = NULL,
  units = "english",
  radius = NULL,
  bin = NULL
)
}
\arguments{
\item{station_id}{an optional string that provides the a 7 character station
id. If omitted the derived product API returns data for all stations.}

\item{resource}{a character string indicating they type of information to
request for a specific station. A list of resource identifiers is available
in the \href{https://api.tidesandcurrents.noaa.gov/mdapi/prod/#Resource}{API Documentation}}

\item{type}{a character string indicating the sensor of interest. Specifying
a sensor of interest returns a data frame with all stations that have the
particular sensor. A list of sensor identifiers is available in the
\href{https://api.tidesandcurrents.noaa.gov/mdapi/prod/#Type}{API Documentation}}

\item{ports}{A two character string indicating specific ports.}

\item{units}{a character string specifying if the data should be returned
using metric or English units. Defaults to \code{'english'}}

\item{radius}{an optional numeric argument indicating the radius in nautical
miles to search for nearby stations}

\item{bin}{an optional (positive integer) argument to requests for currents
station harmonic constituents. If not specified, all the bins will be
returned.}
}
\value{
A data frame. The content of the data frame is dependent on the API
call. See the API documentation for specifics.
}
\description{
Provides easy access to the
\href{https://api.tidesandcurrents.noaa.gov/mdapi/prod/#intro}{CO-OPS Metadata API}.
The api makes information about measurement stations available to users.
Information about a single station or a collection of stations can be
accessed. Depending on the type of station queried different information is
returned.
}
\examples{
\donttest{
# Query a single stations sensors.
sensor_df <- query_metadata('9414290', 'sensors')

# Query all stations
all_stations_df <- query_metadata()
}
}
