% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rnonRLIV}
\alias{rnonRLIV}
\title{Type IV Non-Random Labeling of a Given Set of Points}
\usage{
rnonRLIV(
  dat,
  init.prop,
  ult.prop,
  s1,
  s2,
  rho,
  rand.init = TRUE,
  poisson = FALSE
)
}
\arguments{
\item{dat}{A set of points the non-RL procedure is applied to obtain cases and controls randomly in the 
type IV fashion (see the description).}

\item{init.prop}{A real number between 0 and 1 representing the initial proportion of cases in the data set,
\code{dat}. The selection of the initial cases depends on the parameter \code{rand.init} and the number of initial cases
depends on the parameter poisson (see the description).}

\item{ult.prop}{A real number between 0 and 1 representing the ultimate proportion of cases in the data set,
\code{dat} after the non-RL assignment. The number of ultimate cases depends on the parameter poisson
(see the description).}

\item{s1, s2}{Positive real numbers representing the standard deviations of the first and second components
of the bivariate normal distribution.}

\item{rho}{A real number between -1 and 1 representing the correlation between the first and second components
of the bivariate normal distribution.}

\item{rand.init}{A logical argument (default is \code{TRUE}) to determine the choice of the initial case in the data set, \code{dat}.
If \code{rand.init=TRUE} then the initial case is selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first \eqn{k_0} entries in the data set, \code{dat}, is labeled as the initial case.}

\item{poisson}{A logical argument (default is \code{FALSE}) to determine whether the number of initial and ultimate
cases, \eqn{k_0} and \eqn{n_1}, will be random or fixed. If \code{poisson=TRUE} then the \eqn{k_0} and \eqn{n_1} are from a Poisson distribution,
\eqn{k_0=}\code{rpois(1,round(n*init.prop,0))} and \eqn{n_1=}\code{rpois(1,round(n*ult.prop,0))}
otherwise they are fixed, \eqn{k_0=}\code{round(n*init.prop,0)} and \eqn{n_1=}\code{round(n*ult.prop,0)}.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{="cc"} for the case-control patterns for RL or non-RL of the given data points, \code{dat}}
\item{type}{The type of the point pattern}
\item{parameters}{initial and ultimate proportion of cases after the non-RL procedure is applied to the data,
\code{s1}, \code{s2} and \code{rho} which are standard deviations and the correlation for the components of
the bivariate normal distribution.}
\item{dat.points}{The set of points non-RL procedure is applied to obtain cases and controls randomly in the 
type IV fashion}
\item{lab}{The labels of the points as 1 for cases and 0 for controls after the type IV nonRL procedure is
applied to the data set, \code{dat}. Cases are denoted as red dots and controls as black circles in the plot.}
\item{init.cases}{The initial cases in the data set, \code{dat}. Marked with red crosses in the plot of the points.}
\item{gen.points,ref.points}{Both are \code{NULL} for this function, as initial set of points, \code{dat}, are provided
for the non-RL procedure.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of cases and controls.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Given the set of \eqn{n} points, \code{dat}, in a region, this function assigns \eqn{n_1=}\code{round(n*ult.prop,0)} of them as cases,
and the rest as controls with first selecting \eqn{k_0=}\code{round(n*init.prop,0)} as cases initially and assigning the
label case to the remaining points with infection probabilities equal to the scaled bivariate normal density values
at those points.
The initial and ultimate number of cases will be \eqn{k_0} and \eqn{n_1} on the average if the argument \code{poisson=TRUE}
(i.e., \eqn{k_0=}\code{rpois(1,round(n*init.prop,0)}) and \eqn{n_1=}\code{rpois(1,round(n*ult.prop,0))} ), otherwise
they will be exactly equal to \eqn{n_1=}\code{round(n*ult.prop,0)} and \eqn{k_0=}\code{round(n*init.prop,0)}.
More specifically, let \eqn{z_1,\ldots,z_{k_0}} be the initial cases and for \eqn{j=1,2,\ldots,k_0}
let \eqn{\phi_{G,j}(z_i)} be the value of the pdf of the \eqn{BVN(z_j,s_1,s_2,rho)}, which is the bivariate normal 
distribution mean=z_j and standard deviations of the first and second components being \eqn{s_1}
and \eqn{s_2} (denoted as \code{s1} and \code{s2} as arguments of the function) and 
correlation between them being \eqn{\rho} (denoted as \code{rho} as an argument of the function)
(i.e., the covariance matrix is \eqn{\Sigma=S} where \eqn{S_{11}=s_1^2},
\eqn{S_{22}=s_2^2}, \eqn{S_{12}=S_{21}=s_1 s_2 \rho}). Add these pdf values as
\eqn{p_j=\sum_{j=1}^{k_0} \phi_{G,j}(z_i)} for each \eqn{i=1,2,\ldots,n} and find \eqn{p_{\max}=\max p_j}. 
Then label the points (other than the initial cases) as cases with infection probabilities \code{prob} equal to the value
of the \eqn{p_j/p_{\max}} values at these points. 
We stop when we first exceed \eqn{n_1} cases. \eqn{\rho} has to be in (-1,1) for \code{prob} to be
a valid probability and \eqn{s_1} and \eqn{s_2} must be positive (actually these are required for the BVN density
to be nondegenerately defined).
If \code{rand.init=TRUE}, first \eqn{k_0} entries are chosen as the initial cases in the data set,
\code{dat}, otherwise, \eqn{k_0} initial cases are selected randomly among the data points.

Algorithmically, first all dat points are treated as non-cases (i.e. controls or healthy subjects).
Then the function follows the following steps for labeling of the points: 

step 0: \eqn{n_1} is generated randomly from a Poisson distribution with \code{mean = round(n*ult.prop,0)}, so that the 
average number of ultimate cases will be \code{round(n*ult.prop,0)} if the argument \code{poisson=TRUE}, else \eqn{n_1=}\code{round(n*ult.prop,0)}.
And \eqn{k_0} is generated randomly from a Poisson distribution with \code{mean = round(n*init.prop,0)}, so that the 
average number of initial cases will be round(n*init.prop,0) if the argument \code{poisson=TRUE}, else \eqn{k_0=}\code{round(n*init.prop,0)}. 

step 1: Initially, \eqn{k_0} many points from dat are selected as cases.
The selection of initial cases are determined based on the argument \code{rand.init} (with default=\code{TRUE})
where if \code{rand.init=TRUE} then the initial cases are selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first \eqn{k_0} entries in the data set, \code{dat}, are selected as the cases.

step 2: Then it assigns the label case to the remaining points
with infection probabilities \eqn{prob=\sum_{j=1}^{k_0} \phi_{G,j}(z_i)/p_{\max}},
which is the sum of the BVN densities scaled by the maximum of such sums.
See the description for the details of the parameters in the \code{prob}.

step 3: The procedure ends when number of cases \eqn{n_c} exceed \eqn{n_1}, and \eqn{n_c-n_1} of the cases (other than the initial
cases) are randomly selected and relabeled as controls, i.e. 0s, so that the number of cases is
exactly \eqn{n_1}.

In the output cases are labeled as 1 and controls as 0, and initial contagious case is marked with a red cross
in the plot of the pattern.

See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail where type IV non-RL pattern is the 
case 4 of non-RL pattern considered in Section 6 with \eqn{n_1} and \eqn{k_0} are
fixed as parameters and \code{rho} is represented as \eqn{k_{pow}} and \eqn{rho/k_{den}=1} in the article.

Although the non-RL pattern is described for the case-control setting, it can be adapted for any two-class
setting when it is appropriate to treat one of the classes as cases or one of the classes behave like cases
and other class as controls.
}
\examples{
n<-40;  #try also n<-20; n<-100;
ult<-.5; #try also .25, .75
#data generation
dat<-cbind(runif(n,0,1),runif(n,0,1))

int<-.1
s1<-s2<-.4
rho<- .1

Xdat<-rnonRLIV(dat,int,ult,s1,s2,rho,poisson=FALSE) #labeled data, try also with poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#normal original data
n<-40;  #try also n<-20; n<-100;
dat<-cbind(rnorm(n,0,1),rnorm(n,0,1))
ult<-.5; #try also .25, .75

int<-.1
s1<-s2<-.4
rho<-0.1

Xdat<-rnonRLIV(dat,int,ult,s1,s2,rho,poisson=FALSE) #labeled data, try also with poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)
 
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rnonRLI}}, \code{\link{rnonRLII}}, \code{\link{rnonRLIII}}, and \code{\link{rnonRL}}
}
\author{
Elvan Ceyhan
}
