% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{cov.nnct}
\alias{cov.nnct}
\title{Covariance Matrix of the Cell Counts in an NNCT}
\usage{
cov.nnct(ct, varN, Q, R, byrow = TRUE)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{varN}{The \eqn{k \times k} variance matrix of cell counts of NNCT, \code{ct}.}

\item{Q}{The number of shared NNs}

\item{R}{The number of reflexive NNs (i.e., twice the number of reflexive NN pairs)}

\item{byrow}{A logical argument (default=\code{TRUE}). If \code{TRUE}, rows of \code{ct} are appended to obtain the vector
and if \code{FALSE} columns of \code{ct} are appended to obtain the vector.}
}
\value{
The \eqn{k^2 \times k^2} covariance matrix of cell counts \eqn{N_{ij}} for \eqn{i,j=1,\ldots,k} in the NNCT, \code{ct}
}
\description{
Returns the covariance matrix of cell counts \eqn{N_{ij}} for \eqn{i,j=1,\ldots,k} in the NNCT, \code{ct}. 
The covariance matrix is of dimension \eqn{k^2 \times k^2} and its entries are \eqn{cov(N_{ij},N_{kl})} when \eqn{N_{ij}} values are
by default corresponding to the row-wise vectorization of \code{ct}. If \code{byrow=FALSE}, the column-wise 
vectorization of \code{ct} is used.
These covariances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

cov.nnct(ct,varN,Qv,Rv)
cov.nnct(ct,varN,Qv,Rv,byrow=FALSE)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

cov.nnct(ct,varN,Qv,Rv)
cov.nnct(ct,varN,Qv,Rv,byrow=FALSE)

#1D data points
n<-20  #or try sample(1:20,1)
X<-as.matrix(runif(n))# need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
cov.nnct(ct,varN,Qv,Rv)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{covNrow2col}}, \code{\link{cov.tct}} and \code{\link{cov.nnsym}}
}
\author{
Elvan Ceyhan
}
