% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{EV.Tkinv}
\alias{EV.Tkinv}
\title{Expected Value of Cuzick and Edwards \eqn{T_k^{inv}} Test statistic}
\usage{
EV.Tkinv(n1, n0, k)
}
\arguments{
\item{n1, n0}{The number of cases and controls}

\item{k}{Integer specifying the number of the closest controls to subject \eqn{i}.}
}
\value{
The expected value of Cuzick and Edwards \eqn{T_k^{inv}} test statistic for disease clustering
}
\description{
This function computes the expected value of Cuzick and Edwards \eqn{T_k^{inv}} test statistic which is based on the 
sum of number of cases closer to each case than the \code{k}-th nearest control to the case.

The number of cases are denoted as \eqn{n_1} (denoted as \code{n1} as an argument)
and number of controls as \eqn{n_0} for both functions (denoted as \code{n0} as an argument),
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

See the function \code{\link{ceTkinv}} for the details of the \eqn{T_k^{inv}} test.

See (\insertCite{cuzick:1990;textual}{nnspat}) and references therein.
}
\examples{
n1<-20
n0<-25
k<-2 #try also 2, 3

EV.Tkinv(n1,n0,k)

EV.Tkinv(n1,n0,k=1)
EV.Trun(n1,n0)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTkinv}}, \code{\link{ceTrun}}, and \code{\link{EV.Trun}}
}
\author{
Elvan Ceyhan
}
