% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{get_start}
\alias{get_start}
\title{\code{get_start} get starting values for discrete or continuous choice model.}
\usage{
get_start(
  eq_c = NULL,
  eq_d = NULL,
  data = NULL,
  part = "joint",
  datan = "data",
  fixed_term = FALSE,
  weight_paths = TRUE,
  weight_paths_cont = FALSE,
  data_weight = NULL,
  par_c = NULL,
  par_d = NULL,
  best_method = FALSE,
  startvals = NULL,
  DEoptim_run = FALSE,
  hessian = NULL,
  transform = TRUE,
  MNtypef = "logit",
  pardogit = NULL,
  opt_method = "BFGS",
  numerical_deriv = FALSE
)
}
\arguments{
\item{eq_c}{Continuous equations errors.}

\item{eq_d}{Discrete equations.}

\item{data}{\code{data.frame} is used in the optimization.}

\item{part}{Type of estimation: "joint", "cont", "disc".}

\item{datan}{Name of \code{data.frame} used in the optimization.}

\item{fixed_term}{if \code{TRUE}, includes fixed term in log-likelihood.}

\item{weight_paths}{if \code{TRUE}, weights paths of the whole system.}

\item{weight_paths_cont}{if \code{TRUE}, weight paths only in continuous part.}

\item{data_weight}{\code{data.frame} with weights for continuous and discrete equations,
same dim as \code{data}.}

\item{par_c}{Names of parameters in continuous equations.}

\item{par_d}{Names of parameters in discrete equations.}

\item{best_method}{if \code{TRUE}, try all possible optimization methods and 
choose the one with the smallest likelihood.}

\item{startvals}{Starting values, can be also \code{NULL}.}

\item{DEoptim_run}{if \code{TRUE}, runs DEoptim for the optimization.}

\item{hessian}{Name of hessian function.}

\item{transform}{if \code{TRUE}, quantile transformation is applied.}

\item{MNtypef}{"dogit" or "logit".}

\item{pardogit}{"dogit" parameters.}

\item{opt_method}{optimization method to use.}

\item{numerical_deriv}{if \code{TRUE}, numerical derivatives are calculated in nmm function}
}
\value{
Starting values for discrete or continuous blocks.
}
\description{
\code{get_start} get starting values for discrete or continuous choice model.
}
\examples{
# Example of discrete choice model
data("TravelMode", package = "AER")
eq_d <- c("ASC1 * 1 + B2_t * travel_1 + B3_v * vcost_1" ,
          "ASC2 * 1  + B2_t * travel_2 + B3_v * vcost_2",
          "ASC3 * 1  + B2_t * travel_3 + B3_v * vcost_3",
          "ASC4 * 1  + B2_t * travel_4 + B3_v * vcost_4")
parl <- c(paste0("ASC", 1:4), "B2_t", "B3_v")
obj <- get_par(parl, eq_d)

mode_spec_var <- c("wait", "vcost", "travel", "gcost")
data <- TravelMode
data$wait <- as.numeric(data$wait)
data[data$wait==0,"wait"] <- 0.000001 # add a small number to 0
data$travel <- as.numeric(data$travel)
data[data$travel==0,"travel"] <- 0.000001
data$vcost <- as.numeric(data$vcost)
data[data$vcost==0,"vcost"] <- 0.000001
data <- prepare_data(data, choice="mode", dummy="choice", PeID="individual", WeID="",
type="long", mode_spec_var =mode_spec_var, wc=FALSE)
stv <- get_start(eq_d=eq_d, data=data, datan="data", part="disc", par_d = parl, 
transform = FALSE)

#example, system of equations
data("CreditCard", package="AER")
cdat <- CreditCard
cdat$income2 <- cdat$income^2
cdat$d_selfemp <- as.numeric(cdat$selfemp)
eq_c <- c("expenditure ~  b1*age + b2*income + b3*income2",
"income ~ a1*age + a2*d_selfemp + a3*dependents + a4*majorcards")
parl <- c(paste0("b", 1:3), paste0("a", 1:4))
para_cont <- get_par(parl, eq_c)
cheqs0 <- para_cont$cheqs0
\donttest{
stv <- get_start(eq_c = eq_c, data=cdat, datan="cdat", part="cont", par_c=parl)
}
}
