% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000functions.R
\name{get_par}
\alias{get_par}
\title{\code{get_par} replaces names of parameters with par[i].}
\usage{
get_par(par, object)
}
\arguments{
\item{par}{Names of parameters, vector of character strings.}

\item{object}{List consisting formulas.}
}
\value{
A list object consisting of equations for errors with par[i] (\code{cheqs0}), 
the original list with formulas (\code{eqlab}), vector of parameters (\code{parld}, same as par),
vector of parameters in form of par[i] (\code{parn}, exogenous variables (\code{exog}), 
endogenous variables (\code{endog}, in case of discrete ""), 
number of parameters in each equation (\code{neq_par}).
}
\description{
\code{get_par} replaces names of parameters with par[i].
}
\examples{
# System of Non-linear Regressions
eq_c <- c("hg ~ exp( h0 + h1*log(tht) + h2*tht^2 + h3*elev)",
"dg ~ exp( d0 + d1*log(dbh) + d2*hg + d3*cr)")
par_c <- c(paste0("h", 0:3),paste0("d", 0:3))
para_cont <- get_par(par_c, eq_c)
# Indirect utility functions for discrete choice:
eq_d <- c("a1 + p1 * price_1 + p2 * catch_2", "a2 + p1 * price_2 + p2 * catch_2",
"a3 + p1 * price_3 + p2 * catch_3", "a4 + p1 * price_4 + p2 * catch_4")
par_d <- c(paste0("a", 1:4), paste0("p", 1:2))
disc_par <- get_par(par_d, eq_d)
}
