% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/006functions.R
\name{diagnostics}
\alias{diagnostics}
\title{Goodness of fit measures for both parts}
\usage{
diagnostics(
  x,
  xdigit = 4,
  which = "all",
  only_total = FALSE,
  cPseudoR = TRUE,
  cRs = TRUE
)
}
\arguments{
\item{x}{Fitted \code{nmm} model.}

\item{xdigit}{rounding number}

\item{which}{What to calculate. Options: "all", "RMSE", "MAPE", "Rx2", "Rx2adj".}

\item{only_total}{If \code{TRUE}, calculate statistics only for the whole system}

\item{cPseudoR}{If \code{TRUE}, calculate pseudo R^2s.}

\item{cRs}{Include "AIC", "AICc", "BIC"}
}
\value{
matrix with goodness of fit measures. 
\code{attribute} \code{corr} holds empirical variance-covariance matrix.
}
\description{
Calculation RMSE, misclassification and other goodness of fit measures.
}
\examples{
library(systemfit)
data( ppine , package="systemfit")
hg.formula <- hg ~ exp( h0 + h1*log(tht) + h2*tht^2 + h3*elev)
dg.formula <- dg ~ exp( d0 + d1*log(dbh) + d2*hg + d3*cr)
labels <- list( "height.growth", "diameter.growth" )
model <- list( hg.formula, dg.formula )
start.values <- c(h0=-0.5, h1=0.5, h2=-0.001, h3=0.0001,
                  d0=-0.5, d1=0.009, d2=0.25, d3=0.005)
model.sur <- nlsystemfit( "SUR", model, start.values, data=ppine, eqnlabels=labels )
eq_c <- as.character(c(hg.formula, dg.formula))
parl <- c(paste0("h", 0:3),paste0("d", 0:3))
start.values <- c(h0=-0.5, h1=0.5, h2=-0.001, h3=0.0001,
                  d0=-0.5, d1=0.009, d2=0.25, d3=0.005)
res <- nmm(ppine, eq_c=eq_c, start_v=start.values, par_c=parl, eq_type = "cont",
best_method = FALSE)
ressur <- in2nmm(res, new_coef=model.sur$b)
diagnostics(res)
diagnostics(ressur)

#example discrete
library(mlogit)
data("Fishing", package = "mlogit")
Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")
## a pure "conditional" model
mres <- summary(mlogit(mode ~ price + catch, data = Fish))
data <- prepare_data(Fish \%>\% data.frame \%>\% dplyr::select(-idx), 
choice="alt", dummy="mode", PeID="chid", mode_spec_var = c("price", "catch"),
type="long")
eq_d <- c("a1 + p1 * price_1 + p2 * catch_2", "a2 + p1 * price_2 + p2 * catch_2",
             "a3 + p1 * price_3 + p2 * catch_3", "a4 + p1 * price_4 + p2 * catch_4")
par_d <- c(paste0("a", 1:4), paste0("p", 1:2))
res <- nmm(data, eq_d=eq_d, par_d=par_d,  eq_type="disc")
ncoef <- mres$coefficients
names(ncoef) <- par_d[-1]
resdisc <- in2nmm(res, new_coef = ncoef)
a <- diagnostics(res, xdigit=2)
a2 <- diagnostics(resdisc)
attributes(a2)$corr
}
