% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/003functions.R
\name{LL_joint_no_corr}
\alias{LL_joint_no_corr}
\title{\code{LL_joint_no_corr} Function for log-likelihood without correlation between
 continuous and discrete equations}
\usage{
LL_joint_no_corr(
  ffor,
  cheqs0,
  datan = "data",
  fixed_term = TRUE,
  eq_type = c("joint", "cont", "disc"),
  transform = FALSE,
  hessian = NULL,
  bayesian_random = FALSE,
  eqsys = "sur",
  MNtypef = "logit",
  add_pars = NULL
)
}
\arguments{
\item{ffor}{Discrete equations.}

\item{cheqs0}{Continuous equations.}

\item{datan}{Character string. Name of data-set.}

\item{fixed_term}{if \code{TRUE}, includes fixed term in log-likelihood.}

\item{eq_type}{can be "joint"(both blocks estimated but without correlation), "cont", "disc".}

\item{transform}{if \code{TRUE}, quantile transformation is applied to discrete equations.}

\item{hessian}{Name of hessian function.}

\item{bayesian_random}{If \code{TRUE}, than par[1] is changed to par[,1] to be used for 
optimization of random parameters in Bayesian estimation.}

\item{eqsys}{"sur" or "sem".}

\item{MNtypef}{"logit" or "dogit".}

\item{add_pars}{additional parameters to add}
}
\value{
ML estimation function
}
\description{
\code{LL_joint_no_corr} Function for log-likelihood without correlation between
 continuous and discrete equations
}
\keyword{internal}
