% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_forest.R
\name{thresh_forest}
\alias{thresh_forest}
\title{Producing threshold forest plots}
\usage{
thresh_forest(thresh, y, CI.lo, CI.hi, label, orderby = NULL, data = NULL,
  CI.title = "95\% Confidence Interval", label.title = "",
  y.title = "Mean", II.title = "Invariant Interval", xlab = "",
  xlim = NULL, sigfig = 3, digits = NULL, refline = NULL,
  clinsig = NULL, cutoff = NULL, II.colw = rgb(0.72, 0.8, 0.93),
  II.cols = rgb(0.93, 0.72, 0.8), II.lwd = 8, CI.lwd = 1, pointsize = 4,
  fontsize = 12, xbreaks = NULL, add.columns = NULL,
  add.columns.title = NULL, add.columns.after = -1,
  add.columns.hjust = 0.5, add.columns.uline = TRUE, calcdim = display,
  display = TRUE)
}
\arguments{
\item{thresh}{A \code{thresh} object, as produced by
\code{\link{nma_thresh}}.}

\item{y}{Data points. Either a column of \code{data}, or a numeric vector.}

\item{CI.lo}{Confidence/credible interval lower limits. Either a column of
\code{data}, or a numeric vector.}

\item{CI.hi}{Confidence/credible interval upper limits. Either a column of
\code{data}, or a numeric vector.}

\item{label}{Row labels (for each data point). Either a column of
\code{data}, or a character vector.}

\item{orderby}{Variable(s) to order the table rows by. Either a column or
columns of \code{data}, or a vector. By default, the rows are not
reordered. Further arguments and/or multiple ordering columns may be passed
to the function \code{order} by instead providing a \code{list} containing
the arguments to \code{order}.}

\item{data}{A data frame containing the data points \code{y},
confidence/credible intervals (\code{CI.lo}, \code{CI.hi}), and row labels
\code{labels}. If \code{data} is not provided, the above variables will be
searched for in the calling environment.}

\item{CI.title}{Title for CI column, default "95\% Confidence Interval".}

\item{label.title}{Character string giving the heading for the row labels
column.}

\item{y.title}{Character string giving the heading for the data points
column, default "Mean".}

\item{II.title}{Title for invariant interval column, default "Invariant
Interval".}

\item{xlab}{Character string giving the label for the \eqn{x}-axis.}

\item{xlim}{Numeric vector (length 2) of lower and upper limits for the
\eqn{x}-axis. If not set, tries to choose a sensible default.}

\item{sigfig}{Number of significant digits to display in the table. Default
3.}

\item{digits}{Number of decimal places to display in the table. Overrides
\code{sigfig} if set.}

\item{refline}{\eqn{x} intercept of vertical reference line, if desired.}

\item{clinsig}{Set the clinical significance level. Rows are marked with a
dagger if they have one or more thresholds less than this value. Not set by
default.}

\item{cutoff}{A single numeric value or numeric vector pair. Thresholds
larger in magnitude than this value, or lying outside this interval, will
be cut off and marked as NT (no threshold). Not set by default.}

\item{II.colw}{Colour for "wide" invariant intervals.}

\item{II.cols}{Colour for "short" invariant intervals.}

\item{II.lwd}{Line width of invariant intervals. Default 8.}

\item{CI.lwd}{Line width of confidence/credible intervals. Default 1.}

\item{pointsize}{Point size for forest plot means. Default 4.}

\item{fontsize}{Base font size. Default 12.}

\item{xbreaks}{Position of tick marks on the \eqn{x}-axis as a numeric
vector.}

\item{add.columns}{Data frame (or matrix, vector) of additional columns to
add to table.}

\item{add.columns.title}{Optional titles for the additional columns,
otherwise use names from provided data.}

\item{add.columns.after}{Which column to add the new columns after? Default
adds the columns to the far right.}

\item{add.columns.hjust}{Vector of horizontal justifications for the new
columns, from \code{0} (left) to \code{1} (right). Default centres every
column.}

\item{add.columns.uline}{Underline the header of the new columns? Default
\code{TRUE}.}

\item{calcdim}{Logical, calculate suggested output dimensions for saving to
pdf? Calculates output size when \code{TRUE}; saves time when \code{FALSE}.}

\item{display}{Logical, display the plot? Defaults to \code{TRUE}.}
}
\value{
Displays the forest plot on the current plot device (if \code{display
  = TRUE}). Also returns invisibly the underlying \code{gtable} object, which
  can be further manipulated.
}
\description{
This function produces threshold forest plots, overlaying the
decision-invariant intervals on the data points and their confidence/credible
intervals, as shown by Phillippo \emph{et al.} (2017).
}
\examples{
# Please see the vignette "Examples" for worked examples including use of
# this function, including more information on the brief code below.

vignette("Examples", package = "nmathresh")

### Contrast level thresholds for Thrombolytic treatments NMA
K <- 6   # Number of treatments

# Contrast design matrix is
X <- matrix(ncol = K-1, byrow = TRUE,
            c(1, 0, 0, 0, 0,
              0, 1, 0, 0, 0,
              0, 0, 1, 0, 0,
              0, 0, 0, 1, 0,
              0, -1, 1, 0, 0,
              0, -1, 0, 1, 0,
              0, -1, 0, 0, 1))

# Reconstruct hypothetical likelihood covariance matrix using NNLS
lik.cov <- recon_vcov(Thrombo.post.cov, prior.prec = .0001, X = X)

# Thresholds are then
thresh <- nma_thresh(mean.dk = Thrombo.post.summary$statistics[1:(K-1), "Mean"],
                     lhood = lik.cov,
                     post = Thrombo.post.cov,
                     nmatype = "fixed",
                     X = X,
                     opt.max = FALSE)

# Get treatment codes for the contrasts with data
d.a <- d.b <- vector(length = nrow(X))
for (i in 1:nrow(X)){
  d.a[i] <- ifelse(any(X[i, ] == -1), which(X[i, ] == -1), 0) + 1
  d.b[i] <- ifelse(any(X[i, ] == 1), which(X[i, ] == 1), 0) + 1
}

# Transform from d_ab style contrast references into d[i] style from the full set of contrasts
# for easy indexing in R
d.i <- d_ab2i(d.a, d.b, K = 6)

# Create plot data
plotdat <- data.frame(lab = paste0(d.b, " vs. ", d.a),
                      contr.mean = Thrombo.post.summary$statistics[d.i, "Mean"],
                      CI2.5 = Thrombo.post.summary$quantiles[d.i, "2.5\%"],
                      CI97.5 = Thrombo.post.summary$quantiles[d.i, "97.5\%"])

# Plot
thresh_forest(thresh, contr.mean, CI2.5, CI97.5, label = lab, data = plotdat,
              label.title = "Contrast", xlab = "Log Odds Ratio", CI.title = "95\% Credible Interval",
              xlim = c(-.3, .3), refline = 0, digits = 2)

}
