# fscores.R
#
# created: Jun/19/2015, NU
# last mod: Jul/28/2015, NU

get_factor_scores <- function(object, model, data) {

  if (all(class(object) != "emEst", class(object) != "qmlEst")) {
    stop("object is not of class 'emEst' or 'qmlEst'.")
  }

  ind <- list()
  for (i in seq_len(ncol(model$matrices$class1$Lambda.x))) {
    ind.rows <- seq_len(nrow(model$matrices$class1$Lambda.x))
    lambda.i <- which(model$matrices$class1$Lambda.x[,i] == 0)
    ind[[i]] <- ind.rows[-lambda.i]
  }

  # check if model and object can possibly belong together
  if (object$info$num.x != model$info$num.x || object$info$num.x !=
      model$info$num.x || object$info$num.x != model$info$num.x ||
      object$info$num.x != model$info$num.x || object$info$num.x !=
      model$info$num.x) {
        stop("Result object cannot be generated by this model. Check your model.")
   }

  pars <- coef(object)
  # for number of latent classes > 1
  if (is.list(pars)) {
    fs.l <- lapply(pars, FUN=function(x)fscores(parameters=x,
      num.x=object$info$num.x, num.y=object$info$num.y,
      num.xi=object$info$num.xi, num.eta=object$info$num.eta,
      ind=ind, data=data))

    P <- estep_semm(model=model, parameters=unlist(pars), data=data)

    ws <- NULL
    for (i in seq_len(object$info$num.classes)) {
      ws[[i]] <- fs.l[[i]] * P
    }
    fs <- Reduce("+", ws)

  } else {
    fs <- fscores(parameters=pars, num.x=object$info$num.x,
      num.y=object$info$num.y, num.xi=object$info$num.xi,
      num.eta=object$info$num.eta, ind=ind,
      data=data)
  }
  fs 

}


# Calculate Bartlett factor scores from parameter estimates of structural
# equation model
fscores <- function(parameters, num.x, num.y, num.xi, num.eta, ind, data) {

  pars <- parameters
  psi <- pars[grep("Theta.d", names(pars))]
  
  psihat <- diag(psi[c(unlist(lapply(ind, function(x)x[-1])),
    sapply(ind, function(x)x[1]))])

  beta1 <- pars[grep("Lambda.x", names(pars))]
  beta1hat <- matrix(0, nrow=num.x-num.xi,
    ncol=num.xi)
  
  ind0 <- list()
  for (i in seq_len(length(ind))) {
    if (i == 1) {
      ind0[[i]] <- ind[[i]][-length(ind[[i]])]
    } else {
      ind0[[i]] <- seq_len(length(ind[[i]]) - 1) +
        (ind[[i-1]][length(ind[[i-1]])] - 1)
    }
  }

  for (i in seq_len(ncol(beta1hat))) {
    beta1hat[ind0[[i]], i] <- beta1[ind0[[i]]]
  }

  beta0 <- pars[paste0("nu.x", unlist(lapply(ind, function(x)x[-1])))]
  
  beta0hat <- matrix(0, nrow=num.x-num.xi,
    ncol=num.eta)
  # TODO is num.eta correct here?
  
  for (i in seq_len(ncol(beta0hat))) {
    beta0hat[ind0[[i]], i] <- beta0[ind0[[i]]]
  }

  b1.mod1 <- cbind(matrix(0, nrow=num.xi,
    ncol=num.x-num.xi), diag(num.xi))

  b1.mod2 <- rbind(diag(num.x-num.xi),
    -1*t(beta1hat))
  
  # eq(6)
  Gamma <- b1.mod1 %*% psihat %*% b1.mod2 %*% solve(t(b1.mod2) %*% psihat %*%
           (b1.mod2))
  
  n <- nrow(data)
  # eq(5)
  fs <- matrix(0, nrow=n, ncol=num.xi)
  for(i in 1:n){
    fs[i,] <- cbind(-Gamma, (diag(num.xi) + Gamma %*%
      beta1hat)) %*% (t(as.matrix(data[i,
      seq_len(num.x)])) - rbind(beta0hat, matrix(0,
      num.xi, num.eta)))
  }

  fs
}


