% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbell.R
\name{SSbell}
\alias{SSbell}
\alias{bell}
\title{self start for a bell-shaped curve}
\usage{
bell(x, ymax, a, b, xc)

SSbell(x, ymax, a, b, xc)
}
\arguments{
\item{x}{input vector}

\item{ymax}{maximum value of y}

\item{a}{parameter controlling the spread (associated with a quadratic term)}

\item{b}{parameter controlling the spread (associated with a cubic term)}

\item{xc}{centering parameter}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

bell: vector of the same length as x using a bell-shaped curve
}
\description{
Self starter for a type of bell-shaped curve
}
\details{
This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506). One example application is Hammer et al. (2009) (doi:10.2135/cropsci2008.03.0152).
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:20
y <- bell(x, 8, -0.0314, 0.000317, 13) + rnorm(length(x), 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSbell(x, ymax, a, b, xc), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
