% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gam.R
\name{simulate_gam}
\alias{simulate_gam}
\title{Simulate responses from a generalized additive linear model \code{\link[mgcv]{gam}}}
\usage{
simulate_gam(
  object,
  nsim = 1,
  psim = 1,
  resid.type = c("none", "resample", "normal", "wild"),
  value = c("matrix", "data.frame"),
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[mgcv]{gam}} or \code{\link[stats]{glm}}.}

\item{nsim}{number of simulations to perform}

\item{psim}{parameter simulation level (an integer, 0, 1, 2 or 3).}

\item{resid.type}{type of residual to use. \sQuote{none}, \sQuote{resample}, \sQuote{normal} or \sQuote{wild}.}

\item{value}{either \sQuote{matrix} or \sQuote{data.frame}}

\item{...}{additional arguments (none used at the moment)}
}
\value{
matrix or data.frame with responses
}
\description{
By sampling from the vector of coefficients it is possible to simulate
data from a \sQuote{gam} model.
}
\details{
This function is probably redundant. Simply using \code{\link{simulate}}
generates data from the correct distribution for objects which inherit 
class \code{\link[stats]{lm}}. The difference is that I'm trying to add the 
uncertainty in the parameter estimates.


These are the options that control the parameter simulation level
\describe{
  \item{psim = 0}{returns the fitted values}
  \item{psim = 1}{simulates from a beta vector (mean response)}
  \item{psim = 2}{simulates observations according to the residual type (similar to observed data)}
  \item{psim = 3}{simulates a beta vector, considers uncertainty in the variance covariance matrix of beta and adds residuals (prediction)}
 }
The residual type (resid.type) controls how the residuals are generated. 
They are either resampled, simulated from a normal distribution or \sQuote{wild} where the
Rademacher distribution is used (\url{https://en.wikipedia.org/wiki/Rademacher_distribution}).
Resampled and normal both assume iid, but \sQuote{normal} makes the stronger assumption of normality.
\sQuote{wild} does not assume constant variance, but it assumes symmetry.
}
\note{
psim = 3 is not implemented at the moment.

The purpose of this function is to make it compatible with other functions in this
package. It has some limitations compared to the functions in the \sQuote{see also} section.
}
\examples{
\donttest{
require(ggplot2)
require(mgcv)
## These count data are from GAM book by Simon Wood (pg. 132) - see reference
y <- c(12, 14, 33, 50, 67, 74, 123, 141, 165, 204, 253, 246, 240)
t <- 1:13
dat <- data.frame(y = y, t = t)
fit <- gam(y ~ t + I(t^2), family = poisson, data = dat)
sims <- simulate_gam(fit, nsim = 100, value = "data.frame")

ggplot(data = sims) + 
  geom_line(aes(x = t, y = sim.y, group = ii), 
            color = "gray", alpha = 0.5) + 
  geom_point(aes(x = t, y = y)) 
}

}
\references{
Generalized Additive Models. An Introduction with R. Second Edition. (2017) Simon N. Wood. CRC Press.
}
\seealso{
\code{\link{predict}}, \code{\link[mgcv]{predict.gam}}, \code{\link{simulate}} and \code{\link{simulate_lm}}.
}
