% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foceiFit.R
\name{ofv}
\alias{ofv}
\title{Return the objective function}
\usage{
ofv(x, type, ...)
}
\arguments{
\item{x}{object to return objective function value}

\item{type}{Objective function type value to retrieve or add.

\itemize{

\item{focei} For most models you can specify "focei" and it will
add the focei objective function.

\item{nlme} This switches/chooses the nlme objective function if
   applicable.  This objective function cannot be added if it
   isn't present.

\item{fo} FO objective function value. Cannot be generated

\item{foce} FOCE object function value. Cannot be generated

\item{laplace#} This adds/retrieves  the Laplace objective function value.
The \code{#} represents the number of standard deviations
requested when expanding the Gaussian Quadrature.  This can
currently only be used with saem fits.

\item{gauss#.#} This adds/retrieves the Gaussian Quadrature
approximation of the objective function.  The first number is the
number of nodes to use in the approximation. The second number is
the number of standard deviations to expand upon.

}}

\item{...}{Other arguments sent to ofv for other methods.}
}
\value{
Objective function value
}
\description{
Return the objective function
}
\author{
Matthew Fidler
}
