% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalVoidProbIntegrand.R
\name{marginalVoidProbIntegrand}
\alias{marginalVoidProbIntegrand}
\title{Integrand of the marginal void probability integral}
\usage{
marginalVoidProbIntegrand(
  x,
  lowerCoords,
  upperCoords,
  sd,
  baseIntensities,
  numPoints,
  numWindows
)
}
\arguments{
\item{x}{Matrix of x- and y-coordinates of a set of spatial points. One row corresponds to one point.}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of detection windows. One row for each window.}

\item{sd}{Standard deviation of the isotropic multivariate normal distribution.}

\item{baseIntensities}{Vector of baseline detection intensities for all detection windows.}

\item{numPoints}{Number of points that should be considered. This value (positive integer) is used to truncate \code{x} 
so that extra rows beyond \code{numPoints} are ignored.}

\item{numWindows}{Number of windows. This value (positive integer) is used to truncate \code{lowerCoords} and \code{upperCoords} 
so that extra rows beyond \code{numWindows} are ignored.}
}
\value{
A vector of values of the integrand evaluated at each point of \code{x}.
}
\description{
Integrand of the marginal void probability integral. The domain of this function is the habitat domain.
}
\examples{
x <- matrix(runif(10, 0, 2), nrow = 5)
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
sd <- 0.1
baseIntensities <- c(1:4)
numPoints <- 5
numWindows <- 4
marginalVoidProbIntegrand(x, lowerCoords, upperCoords, sd, baseIntensities, numPoints, numWindows)

}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
