% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeConstantNimbleFunction.R
\name{makeConstantNimbleFunction}
\alias{makeConstantNimbleFunction}
\title{\code{nimble} constant function generator}
\usage{
makeConstantNimbleFunction(inValue, isDouble = TRUE)
}
\arguments{
\item{inValue}{Scalar to be set as a constant}

\item{isDouble}{Logical. If \code{TRUE} the constant is a numeric scalar, and if \code{FALSE} the constant is an integer.}
}
\value{
An object of the type returned by \code{nimbleFunction} that can be called inside
other \code{nimble} code to retrieve the value of the global constant.
}
\description{
Create global constants that can be used in \code{nimble} functions.
As of \code{nimble} 0.6-12 there does not appear to be official support for global constants. 
This function creates functions that can be used in place of constants.
}
\examples{
maxMNormTrunc <- makeConstantNimbleFunction(0.0001, TRUE)   

}
\author{
Joseph D. Chipperfield
}
\keyword{internal}
