% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnormalizer.R
\name{dnormalizer}
\alias{dnormalizer}
\alias{rnormalizer}
\title{Normalizing constant generator}
\usage{
dnormalizer(x, logNormConstant, log = 0)

rnormalizer(n, logNormConstant)
}
\arguments{
\item{x}{Input data, which can be any scalar and will not influence the return value.}

\item{logNormConstant}{Normalizing constant on a log scale.}

\item{log}{Logical. If \code{TRUE} return the log normalizing constant. Otherwise return the normalizing constant.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
The normalizing constant.
}
\description{
A normalizer used for normalizing \code{nimble} distributions. 
It is particularly useful for fitting \code{dpoisppDetection_normal} and \code{dpoisppLocalDetection_normal} models 
using the semi-complete data likelihood approach.
}
\examples{
dnormalizer(1, log(0.5), log = TRUE)
dnormalizer(0, log(0.5), log = FALSE)

}
\author{
Wei Zhang
}
