% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BUGS_nimbleGraph.R
\name{getConditionallyIndependentSets}
\alias{getConditionallyIndependentSets}
\title{Get a list of conditionally independent sets of nodes in a nimble model}
\usage{
getConditionallyIndependentSets(
  model,
  nodes,
  givenNodes,
  omit = integer(),
  explore = c("both", "down", "up"),
  unknownAsGiven = TRUE,
  returnType = "names",
  returnScalarComponents = FALSE,
  endAsGiven = FALSE
)
}
\arguments{
\item{model}{A nimble model object (uncompiled or compiled), such as returned
by \code{nimbleModel}.}

\item{nodes}{A vector of stochastic node names (or their graph IDs) to split
into conditionally independent sets, conditioned on the \code{givenNodes}.
If \code{unknownAsGiven=FALSE}, the \code{nodes} are the starting nodes
from which conditionally independent sets of nodes should be found,
possibly including additional nodes not included in the \code{nodes}
argument. If \code{nodes} is omitted, the default will be all latent nodes
(defined as stochastic nodes that are not data and have at least one
stochastic parent node, possibly with determinstic nodes in-between) that
are a parent of a \code{givenNode} (either provided or default). Note that
this will omit latent states that have no hyperparameters. An example is
the first latent state in some state-space (time-series) models, which is
sometimes declared with known prior.}

\item{givenNodes}{A vector of node names or their graph IDs that should be
considered as fixed (given) and hence can be conditioned on. If omitted,
the default will be all data nodes and all parameter nodes, the latter
defined as nodes with no stochastic parent nodes (skipping over
deterministic parent nodes). See \code{endAsGiven} for a variant on
defaults.}

\item{omit}{A vector of node names or their graph IDs that should be omitted
and should block further graph exploration.}

\item{explore}{The method of graph exploration, which may corresond to what
the \code{nodes} argument represents. For "down", graph exploration starts
only down (towards descendants) from \code{nodes}. For "up", graph
exploration starts only up (towards ancestors) from \code{nodes}. For
"both" (the default and normal setting), both directions are explored.}

\item{unknownAsGiven}{Logical for whether a model node not in \code{nodes} or
\code{givenNodes} should be treated as given (default = TRUE). Otherwise
(and by default) such a node may be grouped into a conditionally
independent set, resulting in more output nodes than input \code{nodes}.}

\item{returnType}{Either "names" for returned nodes to be node names or
"ids" for returned nodes to be graph IDs.}

\item{returnScalarComponents}{If FALSE (default), multivariate nodes are
returned as full names (e.g. \code{x[1:3]}). If TRUE, they are returned as
scalar elements (e.g. \code{x[1]}, \code{x[2]}, \code{x[3]}).}

\item{endAsGiven}{If TRUE, end nodes (defined as nodes with stochastic
parents but no stochastic children, skipping through deterministic nodes)
are included in the default for \code{givenNodes}.}
}
\value{
List of nodes that are in conditionally independent sets. With each
  set, nodes are returned in topologically sorted order. The sets themselves
  are returned in topologically sorted order of their first nodes.

Other nodes (not in \code{nodes}) may be included in the output if
  \code{unknownAsGiven=FALSE}.
}
\description{
A conditionally independent set of nodes is such that the joint probability
(density) of nodes in the set will not change even if any non-given
node outside the set is changed. Default given nodes are data nodes and
parameter nodes (aka "top-level" nodes, i.e. nodes with no parent nodes), but
this can be controlled.
}
\details{
This function returns sets of conditionally independent nodes.
  Multiple input \code{nodes} might be in the same set or different sets.

The \code{nodes} input and the returned sets include only stochastic nodes
because conditional independence is a property of random variables.
Deterministic nodes are considered in determining the sets. \code{givenNodes}
may contain stochastic or deterministic nodes.
}
\author{
Perry de Valpine
}
