% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compFun}
\alias{compFun}
\title{Compare Two Similar Objects including Missing Data Patterns.}
\usage{
compFun(a, b)
}
\arguments{
\item{a}{An object of a given type.}

\item{b}{An object similar in type to that given above.}
}
\value{
Boolean object with \code{TRUE} indicating an element is the same.
}
\description{
Check whether two objects are the same, including patterns of \code{NA}s.
}
\examples{
x <- c(5, 8, 9, NA, 3, NA)
y <- c(5, 2, 9, 4, NA, NA)
compFun(x,y)

x <- matrix(rnorm(1000), ncol = 20)
x[sample(seq(along = x), 100)] <- NA
all(compFun(x,x))
dim(compFun(x,x))

x <- as.list(c(5, 8, 9, NA, 3, NA))
y <- as.list(y)
sapply(compFun(x,y), function(a) sum(!a))

x <- as.data.frame(x)
y <- as.data.frame(y)
sum(!compFun(x,y))
}

