% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermal_oli.R
\name{thermal_oli}
\alias{thermal_oli}
\title{Top of Atmosphere Brightness Temperature}
\usage{
thermal_oli(x, band = c(10, 11), units = c(Celsius, Kelvin, Fahrenheit))
}
\arguments{
\item{x}{A raster containing the Landsat OLI band 10 or 11.}

\item{band}{Specify if your raster is the Landsat OLI band 10 or 11}

\item{units}{specify if your desired units are Celsius, Kelvin, or Fahrenheit degrees}
}
\value{
A raster layer object with the Top of atmosphere brightness temperature.
}
\description{
This function Convert Digital Numbers to Top of Atmosphere Brightness Temperature.
}
\examples{
library(raster)
B10 <- raster(system.file("extdata/3047_20190517_B10.tif", package="nightmares"))
B11 <- raster(system.file("extdata/3047_20190517_B11.tif", package="nightmares"))
thermal_oli(B10, 10, "Celsius")
thermal_oli(B11, 11, "Fahrenheit")

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/using-usgs-landsat-level-1-data-product}.
}
