% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAVI.R
\name{SAVI}
\alias{SAVI}
\title{SAVI - Soil Adjusted Vegetation Index}
\usage{
SAVI(R, NIR)
}
\arguments{
\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
SAVI - Soil Adjusted Vegetation Index.
}
\description{
SAVI is used to correct the Normalized Difference Vegetation Index for the influence of soil brightness in areas where vegetative cover is low.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
SAVI(x[[4]], x[[5]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
