% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ztest.R
\name{plotztest}
\alias{plotztest}
\title{Illustrate a one- or two-tailed z test graphically.}
\usage{
plotztest(z, tails = "two", blank = FALSE, title = "z Test",
  xlabel = "z",
  ylabel = "Density of probability\\nunder the null hypothesis",
  fontfamily = "serif", colormiddle = "aliceblue",
  colorsides = "firebrick3", colormiddlecurve = "black",
  colorsidescurve = "black", colorcut = "black", colorplabel = colorsides,
  theme = "default", signifdigitsp = 3, signifdigitsz = 3,
  curvelinesize = 0.4, cutlinesize = curvelinesize)
}
\arguments{
\item{z}{A numeric value indicating the observed t statistic.}

\item{tails}{A string that indicates whether to plot a one ("one") or two ("two") tailed z-test (optional). By default, a two-tailed test is plotted.}

\item{blank}{A logical that indicates whether to hide (blank = TRUE) the test statistic value, p value and cutline. The corresponding colors are actually only made transparent when blank = TRUE, so that the output is scaled exactly the same (this is useful and especially intended for step-by-step explanations).}

\item{title}{A string or expression indicating a custom title for the plot (optional).}

\item{xlabel}{A string or expression indicating a custom title for the x axis (optional).}

\item{ylabel}{A string or expression indicating a custom title for the y axis (optional).}

\item{fontfamily}{A string indicating the font family of all the titles and labels (e.g. "serif" (default), "sans", "Helvetica", "Palatino", etc.) (optional).}

\item{colormiddle}{A string indicating the color for the "middle" area under the curve (optional).}

\item{colorsides}{A string indicating the color for the "side(s)" area(s) under the curve (optional).}

\item{colormiddlecurve}{A string indicating the color for the "middle" part of the curve (optional).}

\item{colorsidescurve}{A string indicating the color for the "side(s)" part of the curve (optional).}

\item{colorcut}{A string indicating the color for the cut line at the observed test statistic (optional).}

\item{colorplabel}{A string indicating the color for the label of the p-value (optional). By default, for color consistency, this color is the same as color of "colorright".}

\item{theme}{A string indicating one of the predefined color themes. The themes are "default" (light blue and red), "blackandwhite", "whiteandred", "blueandred", "greenandred" and "goldandblue") (optional). Supersedes "colormiddle" and "colorsides" if another argument than "default" is provided.}

\item{signifdigitsp}{A numeric indicating the number of desired significant figures reported for the p-value label (optional).}

\item{signifdigitsz}{A numeric indicating the number of desired significant figures reported for the z label (optional).}

\item{curvelinesize}{A numeric indicating the size of the curve line (optional).}

\item{cutlinesize}{A numeric indicating the size of the cut line(s) (optional). By default, the size of the curve line is used.}
}
\value{
Returns a plot with the density of probability of z under the null hypothesis, annotated with the observed z statistic and the p-value.
}
\description{
This function plots the density probability distribution of a z statistic, with appropriate vertical cutlines at the z value. The p-value and the observed z value are plotted. Although largely customizable, only one argument is required (the observed z statistic) for a two-tailed z test. The optional argument tails = "one" plots a one-tailed test plot (the tail is on the left or right, depending on the sign of the z statistic).
}
\examples{
#Making a z test plot with a z value of 2.
plotztest(z = 2)

#Note that the same can be obtained even quicker with:
plotztest(2)

#The same plot without the z or p value
plotztest(2, blank = TRUE)

#Plotting a one-tailed test using the "tails" parameter.
plotztest(z = 2, tails = "one")

#If a negative t is provided, the tail is on the left.
plotztest(z = -2, tails = "one")

#Changing the fontfamily to "sans" and changing the color theme to "blackandwhite"
plotztest(z = 2, fontfamily = "sans", theme = "blackandwhite")

#Using specific colors and changing the curve line size
plotztest(z = 2, colormiddle = "grey96", colorsides = "indianred", curvelinesize=1)

}
\author{
Nils Myszkowski <nmyszkowski@pace.edu>
}

