% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_path_lengths.R
\name{get_path_members}
\alias{get_path_members}
\title{Get Path Members}
\usage{
get_path_members(outlets, network, cores = 1, status = FALSE)
}
\arguments{
\item{outlets}{vector of IDs from data.frame}

\item{network}{data.frame with ID, toID, and lengthkm attributes.}

\item{cores}{integer number of cores to use for parallel computation.}

\item{status}{logical print status and progress bars?}
}
\value{
list of lists containing flowpath identifiers along path that connect
outlets.
}
\description{
Given a network and set of IDs, finds paths between all
identified flowpath outlets. This algorithm finds members between outlets
regardless of flow direction.
}
\examples{
source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))
fline <- walker_flowline

outlets <- c(5329303, 5329357, 5329317, 5329365, 5329435, 5329817)

# Add toCOMID
fline <- nhdplusTools::get_tocomid(fline, add = TRUE)

fl <- dplyr::select(fline, ID = comid, toID = tocomid, lengthkm)

get_path_members(outlets, fl)

}
