% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesAttr}
\alias{nhanesAttr}
\title{Returns the attributes of an NHANES data table}
\usage{
nhanesAttr(year, nh_table)
}
\arguments{
\item{year}{The year in yyyy format where 1999 <= yyyy <= 2012}

\item{nh_table}{The name of the specific table to retrieve}
}
\value{
The following attributes are returned as a list \cr
nrow = number of rows \cr
ncol = number of columns \cr
names = name of each column \cr
unique = true if all SEQN values are unique \cr
na = number of 'NA' cells in the table \cr
size = total size of table in bytes \cr
types = data types of each column
}
\description{
Returns the attributes of an NHANES data table
}
\details{
nhanesAttr allows one to check the size and other charactersistics of a data table
before importing into R. To retrieve these characteristics, the specified table is downloaded,
characteristics are determined, then the table is deleted.
}
\examples{
nhanesAttr(2007, 'BPX_E')
nhanesAttr(2009, 'FOLATE_F')
}

