% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_utils.R
\name{get_pp_samplegroup}
\alias{get_pp_samplegroup}
\title{Function to get samplegroup file that can be pass to Proteinpaint}
\usage{
get_pp_samplegroup(samples, group, outfn = NULL)
}
\arguments{
\item{samples}{A vector indicating all samples}

\item{group}{A vector indicating the group information}

\item{outfn}{Default is NULL and not output the result to file}
}
\value{
A data frame
}
\description{
Function to get samplegroup file that can be pass to Proteinpaint
}
\examples{
samples <- sprintf('A\%s', 1:7)
group <- 'B-ALL'
samplegroup <- get_pp_samplegroup(samples, group)
outfn <- tempfile()
samplegroup <- get_pp_samplegroup(samples, group, outfn)
}
