% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitter.r
\name{splitter}
\alias{splitter}
\title{Character Splitter}
\usage{
splitter(string, split.char = FALSE, split.space = TRUE, spacesep = "_",
  split.punct = FALSE)
}
\arguments{
\item{string}{An input string.}

\item{split.char}{Logical; should a split occur after every character?}

\item{split.space}{Logical; determines if spaces should be preserved as characters in
the n-gram tokenization.  The character(s) used for spaces are
determined by the \code{spacesep} argument.
characters.}

\item{spacesep}{The character(s) to represent a space in the case that
\code{split.space=TRUE}.  Should not just be a space(s).}

\item{split.punct}{Logical; determines if splits should occur at punctuation.}
}
\value{
A string.
}
\description{
A utility function for use with n-gram modeling.  This function
splits a string based on various options.
}
\details{
Note that choosing \code{split.char=TRUE} necessarily implies 
\code{split.punct=TRUE} as well --- but \emph{not} necessarily that
\code{split.space=TRUE}.
}
\examples{
x <- "watch out! a snake!"

splitter(x, split.char=TRUE)
splitter(x, split.space=TRUE, spacesep="_")
splitter(x, split.punct=TRUE)


}
\keyword{Preprocessing}
