% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_conference_seeds.R
\name{compute_conference_seeds}
\alias{compute_conference_seeds}
\title{Compute NFL Playoff Seedings using Game Results and Divisional Rankings}
\usage{
compute_conference_seeds(
  teams,
  h2h = NULL,
  tiebreaker_depth = 3,
  .debug = FALSE,
  playoff_seeds = 7
)
}
\arguments{
\item{teams}{The division standings data frame as computed by
\code{\link{compute_division_ranks}}}

\item{h2h}{A data frame that is used for head-to-head tiebreakers across the
tie-breaking functions. It is computed by the function
\code{\link{compute_division_ranks}}.}

\item{tiebreaker_depth}{A single value equal to 1, 2, or 3. The default is 3. The
value controls the depth of tiebreakers that shall be applied. The deepest
currently implemented tiebreaker is strength of schedule. The following
values are valid:
\describe{
\item{tiebreaker_depth = 1}{Break all ties with a coinflip. Fastest variant.}
\item{tiebreaker_depth = 2}{Apply head-to-head and division win percentage tiebreakers. Random if still tied.}
\item{tiebreaker_depth = 3}{Apply all tiebreakers through strength of schedule. Random if still tied.}
}}

\item{.debug}{Either \code{TRUE} or \code{FALSE}. Controls whether additional
messages are printed to the console showing what the tie-breaking algorithms
are currently performing.}

\item{playoff_seeds}{Number of playoff teams per conference (increased
in 2020 from 6 to 7).}
}
\value{
A data frame of division standings including playoff seeds and the
week in which the season ended for the respective team (\code{exit}).

A list of two data frames:
\describe{
\item{standings}{Division standings including playoff seeds.}
\item{h2h}{A data frame that is used for head-to-head tiebreakers across the
tie-breaking functions.}
}
}
\description{
Compute NFL Playoff Seedings using Game Results and Divisional Rankings
}
\examples{
\donttest{
# Change some options for better output
old <- options(list(digits = 3, tibble.print_min = 64))
library(dplyr, warn.conflicts = FALSE)

try({#to avoid CRAN test problems
nflseedR::load_sharpe_games() \%>\%
  dplyr::filter(season \%in\% 2019:2020) \%>\%
  dplyr::select(sim = season, game_type, week, away_team, home_team, result) \%>\%
  nflseedR::compute_division_ranks() \%>\%
  nflseedR::compute_conference_seeds(h2h = .$h2h) \%>\%
  purrr::pluck("standings")
})

# Restore old options
options(old)
}
}
\seealso{
The examples \href{https://nflseedr.com/articles/articles/nflseedR.html}{on the package website}
}
