% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_everything.R
\name{get_everything}
\alias{get_everything}
\title{Get resources of newsapi.org}
\usage{
get_everything(query, sources = NULL, domains = NULL,
  exclude_domains = NULL, from = NULL, to = NULL, language = NULL,
  sort_by = "publishedAt", page = 1, page_size = 100,
  api_key = Sys.getenv("NEWS_API_KEY"))
}
\arguments{
\item{query}{Character string that contains the searchterm for the API's
data base. API supports advanced search parameters, see 'details'.
Passing a searchterm is compulsory.}

\item{sources}{Character vector with with IDs of the news outlets
you want to focus on (e.g., c("usa-today", "spiegel-online")).}

\item{domains}{Character vector with domains that you want
to restrict your search to (e.g. c("bbc.com", "nytimes.com")).}

\item{exclude_domains}{Similar usage as with 'domains'. Will exclude these
domains from your search.}

\item{from}{Character string with start date of your search. Needs to conform
to one of the following lubridate order strings: 
\code{"ymdHMs, ymdHMsz, ymd"}. See help for lubridate::parse_date_time. 
If from is not specified, NewsAPI defaults to the oldest available date 
(depends on your paid/unpaid plan from newsapi.org).}

\item{to}{Character string that marks the end date of your search. Needs to conform
to one of the following lubridate order strings: 
\code{"ymdHMs, ymdHMsz, ymd"}. See help for lubridate::parse_date_time. 
If \code{to} is not specified, 
NewsAPI defaults to the most recent article available.}

\item{language}{Specifies the language of the articles of your search. Must
be in ISO shortcut format (e.g., "de", "en"). See list of all
languages using \code{newsanchor::terms_language}. Default
is all languages.}

\item{sort_by}{Character string that specifies the sorting variable of your article
results. Accepts three options: "publishedAt", "relevancy",
"popularity". Default is "publishedAt".}

\item{page}{Specifies the page number of your results that is returned. Must
be numeric. Default is first page. If you want to get all results
at once, use \code{get_everything_all} from 'newsanchor'.}

\item{page_size}{The number of articles per page that are returned.
Maximum is 100 (also default).}

\item{api_key}{Character string with the API key you get from newsapi.org.
Passing it is compulsory. Alternatively, function can be
provided from the global environment (see \code{set_api_key()}).}
}
\value{
List with two dataframes:\cr
        1) Data frame with \code{results_df}\cr
        2) Data frame with \code{meta_data}
}
\description{
\code{get_everything} returns articles from large and small news
sources and blogs. This includes news as well as other regular articles.
You can search for multiple \code{sources}, different \code{language},
or use your own keywords. Articles can be sorted by the earliest date
\code{publishedAt}, \code{relevancy}, or \code{popularity}. To automatically
download all results, use \code{get_everything_all()}.\cr\cr
Please check that the \code{api_key} is available. You can provide an explicit
definition of the key or use \code{set_api_key()}. \cr\cr
Valid languages for \code{language} are provided in the dataset
\code{terms_language}.
}
\details{
Advanced search (see also www.newsapi.org): Surround entire phrases
         with quotes (") for exact matches. Prepend words/phrases that must
         appear with "+" symbol (e.g., +bitcoin). Prepend words that must not
         appear with "-" symbol (e.g., -bitcoin). You can also use AND, OR,
         NOT keywords (optionally grouped with parenthesis, e.g., 'crypto AND
         (ethereum OR litecoin) NOT bitcoin)'). \cr
}
\examples{
\dontrun{
df <- get_everything(query = "stuttgart", language = "de")
df <- get_everything(query = "mannheim", from = "2019-01-02 12:00:00")
}
}
