% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epkd.R
\name{epkd}
\alias{epkd}
\alias{depkd}
\alias{pepkd}
\alias{qepkd}
\alias{repkd}
\title{Estimation procedures for kumaraswamy distribution parameters under adaptive
type-II hybrid progressive censoring}
\usage{
depkd(x, lambda, alpha, log = FALSE)

pepkd(q, lambda, alpha, lower.tail = TRUE, log.p = FALSE)

qepkd(p, lambda, alpha, lower.tail = TRUE)

repkd(n, lambda, alpha)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, lambda}{are non-negative shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{depkd} gives the density, \code{pepkd} gives the distribution
function, \code{qepkd} gives the quantile function and \code{repkd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
Estimation procedures for kumaraswamy distribution with parameters
\code{shapes}.
}
\details{
Estimation procedures for kumaraswamy distribution with non-negative shape
parameters \eqn{\alpha}, \eqn{\lambda} has density given by
\deqn{f\left( x\right) =\alpha \lambda x^{\lambda -1}\left( 1-x^{\lambda }
\right)^{\alpha -1},}
where
\deqn{0<x<1,~~\alpha ,\lambda >0.}
}
\examples{
library("new.dist")
depkd(0.1,lambda=2,alpha=3)
pepkd(0.5,lambda=2,alpha=3)
qepkd(.8,lambda=2,alpha=3)
repkd(10,lambda=2,alpha=3)
}
\references{
Kohansal, A. ve Bakouch, H. S., 2021,
\emph{Estimation procedures for Kumaraswamy distribution parameters under
adaptive type-II hybrid progressive censoring}, Communications in
Statistics-Simulation and Computation, 50 (12), 4059-4078.
}
