% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yth_filter.R
\name{yth_filter}
\alias{yth_filter}
\title{Filtered xts object}
\usage{
yth_filter(x, h = 8, p = 4, output = c("x", "trend", "cycle", "random"),
  ...)
}
\arguments{
\item{x}{A univariate \code{\link{xts}} object of any \code{\link{zoo}} index class,
such as \code{\link{Date}}, \code{\link{yearmon}}, or \code{\link{yearqtr}}.
For converting objects of type \code{timeSeries, ts, irts, fts, matrix, data.frame}
or \code{zoo}, please read \code{\link{as.xts}}.}

\item{h}{An \code{\link{integer}}, defining the lookahead period.
Defaults to \code{h = 8}. The default assumes economic data of quarterly 
periodicity with a lookahead period of 2 years. This function is not limited 
by the default parameter, and Econometricians may change it as required.}

\item{p}{An \code{\link{integer}}, indicating the number of lags. A Default of 
\code{p = 4}, assumes data is of quarterly periodicity. If data is of monthly 
periodicity, one may choose \code{p = 12} or aggregate the series to quarterly 
periodicity and maintain the default. Econometricians should use this parameter 
to accommodate the Seasonality of their data.}

\item{output}{A \code{\link{character}} vector. Defaults to \code{output = c("x","trend", "cycle", "random")}, which returns the original time series 
(\code{x}), yth_glm \code{\link{fitted.values}} (\code{"trend"}), yth_glm \code{\link{residuals}}
(\code{"cycle"}), and a random walk series defined by differencing \eqn{y_{t+h}} 
and \eqn{y_t} (\code{"random"}). Arguments \code{"x"}, \code{"trend"}, \code{"cycle"}, and 
\code{"random"} extract their corresponding univariate series and can be merged in any combination.
For example \code{c("x", "trend")} returns both the original series "x" and the "trend" components. 
\code{c("cycle", "random")} will return both the "cycle" and "random" components.}

\item{...}{other arguments passed to the function \code{\link[stats]{glm}}}
}
\value{
An \code{\link{xts}} object defined by the \code{output} parameter.
}
\description{
\code{yth_filter} returns an \code{\link{xts}} object containing user defined
 combinations of the original, trend, cycle, and random walk series.
}
\details{
For time series of quarterly periodicity, Hamilton suggests parameters of
 h = 8 and p = 4, or an \eqn{AR(4)} process, additionally lagged by \eqn{8}
 lookahead periods. Econometricians may explore variations of h. However, p 
 is designed to correspond with the seasonality of a given periodicity and 
 should be matched accordingly.
 \deqn{y_{t+h} = \beta_0 + \beta_1 y_t + \beta_2 y_{t-1} + \beta_3 y_{t-2} + \beta_4 y_{t-3} + v_{t+h}}
 \deqn{\hat{v}_{t+h} = y_{t+h} - \hat{\beta}_0 + \hat{\beta}_1 y_t + \hat{\beta}_2 y_{t-1} + \hat{\beta}_3 y_{t-2} + \hat{\beta}_4 y_{t-3}}
 Which can be rewritten as:
 \deqn{y_{t} = \beta_0 + \beta_1 y_{t-8} + \beta_2 y_{t-9} + \beta_3 y_{t-10} + \beta_4 y_{t-11} + v_{t}}
 \deqn{\hat{v}_{t} = y_{t} - \hat{\beta}_0 + \hat{\beta}_1 y_{t-8} + \hat{\beta}_2 y_{t-9} + \hat{\beta}_3 y_{t-10} + \hat{\beta}_4 y_{t-11}}
}
\examples{
data(GDPC1)

gdp_filter <- yth_filter(100*log(GDPC1), h = 8, p = 4)

knitr::kable(head(gdp_filter, 15), align = 'l')

#---------------------------------------------------------------------------#

data(PAYEMS)

log_Employment <- 100*log(xts::to.quarterly(PAYEMS["1947/2016-6"], OHLC = FALSE))

employ_trend <- yth_filter(log_Employment, h = 8, p = 4, output = c("x", "trend"))

plot(employ_trend, grid.col = "white", legend.loc = "topleft", 
         main = "Log of Employment and trend")

#----------------------------------------------------------------------------#

quarterly_data <- 100*log(merge(GDPC1, PCECC96, GPDIC1, EXPGSC1, IMPGSC1, GCEC1, GDPDEF))

cycle <- do.call(merge, lapply(quarterly_data, yth_filter, output = "cycle"))
random <- do.call(merge, lapply(quarterly_data, yth_filter, output = "random"))

cycle.sd <- t(data.frame(lapply(cycle, sd, na.rm = TRUE)))
GDP.cor <- t(data.frame(lapply(cycle, cor, cycle[,1], use = "complete.obs")))
random.sd <- t(data.frame(lapply(random, sd, na.rm = TRUE)))
random.cor <- t(data.frame(lapply(random, cor, random[,1], use = "complete.obs")))

my_table_2 <- round(data.frame(cbind(cycle.sd, GDP.cor, random.sd, random.cor)), 2)

knitr::kable(my_table_2, align = 'l')
}
\references{
James D. Hamilton. \href{http://econweb.ucsd.edu/~jhamilto/hp.pdf}{Why You Should Never Use the Hodrick-Prescott Filter}.
           NBER Working Paper No. 23429, Issued in May 2017.
}
\seealso{
\code{\link{yth_glm}}
}
