% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvd-class.R
\name{mean.nvd}
\alias{mean.nvd}
\title{Fréchet Mean of Network-Valued Data}
\usage{
\method{mean}{nvd}(x, weights = rep(1, length(x)), representation = "adjacency", ...)
}
\arguments{
\item{x}{An \code{\link{nvd}} object.}

\item{weights}{A numeric vector specifying weights for each observation
(default: equally weighted).}

\item{representation}{A string specifying the graph representation to be
used. Choices are adjacency, laplacian, modularity, graphon. Default is
adjacency.}

\item{...}{Other argument to be parsed to the \code{\link[base]{mean}}
function.}
}
\value{
The mean network in the chosen matrix representation assuming
Euclidean geometry for now.
}
\description{
This function computes the sample Fréchet mean from an observed sample of
network-valued random variables according to a specified matrix
representation. It currently only supports the Euclidean geometry i.e. the
sample Fréchet mean is obtained as the argmin of the sum of squared Frobenius
distances.
}
\examples{
d <- nvd(n = 10L)
mean(d)
}
