% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVector.R, R/SparseBrainVector.R
\docType{methods}
\name{takeVolume}
\alias{takeVolume}
\alias{takeVolume,BrainVector,numeric-method}
\alias{takeVolume,SparseBrainVector,numeric-method}
\title{Generic function to extract a one or more individual volumes from a four-dimensional image}
\usage{
takeVolume(x, i, ...)

\S4method{takeVolume}{BrainVector,numeric}(x, i, merge = FALSE)

\S4method{takeVolume}{SparseBrainVector,numeric}(x, i, merge = FALSE)
}
\arguments{
\item{x}{four-dimensional image}

\item{i}{the indices of the volume(s) to extract}

\item{...}{additional arguments}

\item{merge}{concatenate extracted volumes}
}
\value{
a list of \code{BrainVolume} elements
}
\description{
Generic function to extract a one or more individual volumes from a four-dimensional image
}
\examples{
bvec <- BrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), BrainSpace(c(24,24,24,24), c(1,1,1)))
vol <- takeVolume(bvec,1)
all.equal(dim(vol), c(24,24,24))

vol <- takeVolume(bvec,1:3)
length(vol) == 3
class(vol) == "list"
}

