% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_dti.R
\docType{methods}
\name{subset_dti-methods}
\alias{subset_dti-methods}
\alias{subset_dti}
\alias{subset_dti,nifti-method}
\alias{subset_dti,ANY-method}
\alias{subset_dti,character-method}
\alias{subset_dti,list-method}
\title{Subset DTI data based on b-values
#'}
\usage{
subset_dti(img, bvals, bvecs, b_step = 1, maximum = Inf,
  shells = NULL, verbose = TRUE, ...)

\S4method{subset_dti}{nifti}(img, bvals, bvecs, b_step = 1,
  maximum = Inf, shells = NULL, verbose = TRUE, ...)

\S4method{subset_dti}{ANY}(img, bvals, bvecs, b_step = 1,
  maximum = Inf, shells = NULL, verbose = TRUE, ...)

\S4method{subset_dti}{character}(img, bvals, bvecs, b_step = 1,
  maximum = Inf, shells = NULL, verbose = TRUE, ...)

\S4method{subset_dti}{list}(img, bvals, bvecs, b_step = 1,
  maximum = Inf, shells = NULL, verbose = TRUE, ...)
}
\arguments{
\item{img}{character or \code{nifti} object}

\item{bvals}{filename of b-values (assuming 1 row)}

\item{bvecs}{filename of b-vectors (assuming 3 rows)}

\item{b_step}{step of b-values to round to}

\item{maximum}{maximum b-value threshold}

\item{shells}{Shells to keep (after rounding)}

\item{verbose}{print diagnostic messages}

\item{...}{options passed to \code{\link{checkimg}}}
}
\value{
List of filenames of 
image, b-values, and b-vectors that were subsetted.
}
\description{
Subset DTI data based on b-values
#'
}
\examples{
\dontrun{
img = "~/Downloads/data.nii.gz"
bvals = "~/Downloads/bvals"
bvecs = "~/Downloads/bvals"
verbose = TRUE
b_step = 50
maximum = 1500
shells = NULL
sub = subset_dti(img = img, bvals = bvals, bvecs = bvecs, 
maximum = 1500,
b_step = 50)

}
}
\author{
John Muschelli \email{muschellij2@gmail.com}
}
