% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_img.R
\name{window_img}
\alias{window_img}
\title{nifti image windower}
\usage{
window_img(x, window = c(0, 100), replace = c("window", "missing",
  "zero"), ...)
}
\arguments{
\item{x}{is either a character name for the image or an object of class nifti}

\item{window}{numeric of length 2 that gives min and max for window}

\item{replace}{either "window" if the any values outside of c(min, max) are
set to the min or max or "missing" for these to be set to NA}

\item{...}{not used}
}
\value{
Object of class nifti
}
\description{
Windows an image to min and max values and also changes
cal_max and cal_min parameters
}
\examples{
  set.seed(5)
  dims = rep(10, 3)
  arr = array(rnorm(prod(dims)), dim = dims)
  nim = oro.nifti::nifti(arr)
  window_img(nim, window = c(1, 5))
  window_img(nim, window = c(1, 5), replace = "missing")
  tfile = tempimg(nim)
  window_img(tfile)
  window_img(as.factor(tfile))
  arr = window_img(img_data(nim))
  rnim = RNifti::readNifti(tfile)
  window_img(rnim, window = c(1, 5))
  range(window_img(rnim, window = c(1, 5)))
  window_img(rnim, window = c(1, 5), replace = "missing")
  range(window_img(rnim, window = c(1, 5), replace = "missing"))
   

}
\seealso{
\link{readnii}
}
