% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.expectedInf}
\alias{plot.expectedInf}
\title{Plot "expectedInf" objects}
\usage{
\method{plot}{expectedInf}(x, order = c("given", "alphabetical",
  "value"), zscore = TRUE, ...)
}
\arguments{
\item{x}{an output object from an \code{expectedInf} (class \code{expectedInf})}

\item{order}{"alphabetical" orders nodes alphabetically, "value" orders nodes from
highest to lowest impact value}

\item{zscore}{logical. Converts raw impact statistics to z-scores for plotting}

\item{...}{other plotting specifications (ggplot2)}
}
\description{
Convenience function for plotting expected influence
}
\details{
Inputting an object of class \code{expectedInf}
will return a line plot that shows the relative one-step and/or two-step
expected influence of each node.
}
\examples{
myNetwork <- cor(depression[,1:5])
out1 <- expectedInf(myNetwork)
plot(out1$step1)
\donttest{
plot(out1, order="value", zscore=TRUE)
}
}
