% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedInf.R
\name{expectedInf}
\alias{expectedInf}
\title{Expected Influence}
\usage{
expectedInf(network, step = c("both", 1, 2), directed = FALSE)
}
\arguments{
\item{network}{an object of type \code{qgraph}, \code{igraph}, or an adjacency
matrix representing a network. Adjacency matrices should be complete (e.g., not
only upper or lower half)}

\item{step}{compute 1-step expected influence, 2-step expected influence,
or both}

\item{directed}{logical. Specifies if edges are directed, defaults to FALSE}
}
\description{
Calculates the one-step and two-step expected influence of each node.
}
\details{
When a network contains both positive and negative edges, traditional centrality measures
such as strength centrality may not accurately predict node influence on the network.
Robinaugh, Millner, & McNally (2016) showed that in these cases,
expected influence is a more appropriate measure.

One-step expected influence is defined as the sum of all edges extending
from a given node (where the sign of each edge is maintained).

Two-step expected influence, as the name implies, measures connectivity up to two edges away from the node.
It is defined as the sum of the (weighted) expected influences of each node connected to the initial node
plus the one-step expected influence of the initial node. Weights are determined by the edge strength between
the initial node and each "second step" node.

See citations in the references section for further details.
}
\examples{
out1 <- expectedInf(cor(depression[,1:5]))
\donttest{
out1$step1
out1$step2
plot(out1)
plot(out1, order="value", zscore=TRUE)

igraph_obj <- igraph::graph_from_adjacency_matrix(cor(depression))
out_igraph <- expectedInf(igraph_obj)

qgraph_obj <- qgraph::qgraph(cor(depression), DoNotPlot=TRUE)
out_qgraph <- expectedInf(qgraph_obj)

Ising_adj_mat <- IsingFit::IsingFit(social, plot=FALSE)$weiadj
out_Ising <- expectedInf(Ising_adj_mat)
plot(out_Ising)
}
}
\references{
Robinaugh, D. J., Millner, A. J., & McNally, R. J. (2016). Identifying highly influential nodes in the complicated grief network. \emph{Journal of abnormal psychology}, 125, 747.
}
