% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximate.ranks.R
\name{approx_rank_relative}
\alias{approx_rank_relative}
\title{Approximation of relative rank probabilities}
\usage{
approx_rank_relative(P, iterative = TRUE, num.iter = 10)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{iterative}{Logical scalar if iterative approximation should be used.}

\item{num.iter}{Number of iterations to be used. defaults to 10 (see Details).}
}
\value{
a matrix containing approximation of relative rank probabilities.
\code{relative.rank[i,j]} is the probability that i is ranked lower than j
}
\description{
Approximate relative rank probabilities \eqn{P(rk(u)<rk(v))}.
In a network context, \eqn{P(rk(u)<rk(v))} is the probability that u is
less central than v, given the partial ranking P.
}
\details{
The iterative approach generally gives better approximations
than the non iterative, if only slightly. The default number of iterations
is based on the observation, that the approximation does not improve
significantly beyond this value. This observation, however, is based on
very small networks such that increasing it for large network may yield
better results. See \code{vignette("benchmarks",package="netrankr")} for more details.
}
\examples{
P <- matrix(c(0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, rep(0, 10)), 5, 5, byrow = TRUE)
P
approx_rank_relative(P, iterative = FALSE)
approx_rank_relative(P, iterative = TRUE)
}
\references{
De Loof, K. and De Baets, B and De Meyer, H., 2008. Properties of mutual
rank probabilities in partially ordered sets. In \emph{Multicriteria Ordering and
Ranking: Partial Orders, Ambiguities and Applied Issues}, 145-165.
}
\seealso{
\link{approx_rank_expected}, \link{exact_rank_prob}, \link{mcmc_rank_prob}
}
\author{
David Schoch
}
