% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.netcomb.R
\name{print.summary.netcomb}
\alias{print.summary.netcomb}
\title{Print detailed information for component network meta-analysis}
\usage{
\method{print}{summary.netcomb}(
  x,
  common = x$x$common,
  random = x$x$random,
  backtransf = x$backtransf,
  nchar.comps = x$nchar.comps,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  big.mark = gs("big.mark"),
  legend = TRUE,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.netcomb}}

\item{common}{A logical indicating whether results for the common
effects model should be printed.}

\item{random}{A logical indicating whether results for the random
effects model should be printed.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf=TRUE}, results for \code{sm="OR"} are presented
as odds ratios rather than log odds ratios, for example.}

\item{nchar.comps}{A numeric defining the minimum number of
characters used to create unique component names.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistics, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
effects should be printed according to JAMA reporting standards.}

\item{big.mark}{A character used as thousands separator.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments.}
}
\description{
Print detailed information  for component network meta-analysis.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Conduct random effects network meta-analysis
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
  data = face, reference.group = "placebo",
  sm = "OR", common = FALSE)

# Additive model for treatment components
#
nc1 <- netcomb(net1)
print(summary(nc1), digits = 2)

}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}},
  \code{\link{summary.netcomb}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
