% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.netdose.R
\name{print.netdose}
\alias{print.netdose}
\title{Print method for objects of class \code{netdose}}
\usage{
\method{print}{netdose}(
  x,
  common = x$common,
  random = x$random,
  backtransf = x$backtransf,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = gs("digits.I2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{netdose}.}

\item{common}{A logical indicating whether results from the common effects model should be printed.}

\item{random}{A logical indicating whether results from the random effects model should be printed.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf = TRUE}, results
for \code{sm = "OR"} are printed as odds ratios rather than log
odds ratios, for example.}

\item{digits}{Minimal number of significant digits to be used in output.}

\item{digits.stat}{Number of decimal places for test statistics.}

\item{digits.pval}{Number of decimal places for p-values.}

\item{digits.pval.Q}{Number of decimal places for Q-test p-value.}

\item{digits.Q}{Number of decimal places for Q statistic.}

\item{digits.tau2}{Number of decimal places for tau-squared.}

\item{digits.tau}{Number of decimal places for tau.}

\item{digits.I2}{Number of decimal places for I-squared.}

\item{scientific.pval}{A logical indicating whether p-values should be printed in scientific notation.}

\item{big.mark}{A character used as thousands separator.}

\item{text.tau2}{A character string used to label tau-squared in the output.}

\item{text.tau}{A character string used to label tau in the output.}

\item{text.I2}{A character string used to label I-squared in the output.}

\item{...}{Additional arguments (ignored).}
}
\value{
The input object is printed to the console. No return value.
}
\description{
Displays a summary of the dose-response network meta-analysis results stored in a \code{netdose} object.
}
