% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.r
\name{rescale_vertex_igraph}
\alias{rescale_vertex_igraph}
\alias{igraph_vertex_rescale}
\alias{vertex_rescale_igraph}
\title{Rescale vertex size to be used in \code{\link[igraph:plot.igraph]{plot.igraph}}.}
\usage{
rescale_vertex_igraph(
  vertex.size,
  par.usr = par("usr"),
  minmax.relative.size = getOption("diffnet.minmax.relative.size", c(0.01, 0.04)),
  adjust = 200
)

igraph_vertex_rescale(
  vertex.size,
  par.usr = par("usr"),
  minmax.relative.size = getOption("diffnet.minmax.relative.size", c(0.01, 0.04)),
  adjust = 200
)

vertex_rescale_igraph(
  vertex.size,
  par.usr = par("usr"),
  minmax.relative.size = getOption("diffnet.minmax.relative.size", c(0.01, 0.04)),
  adjust = 200
)
}
\arguments{
\item{vertex.size}{Numeric vector of unscaled vertices' sizes. This is unit-free.}

\item{par.usr}{Integer vector of length 4 with the coordinates of plotting region.
by default uses \code{par("usr")}.}

\item{minmax.relative.size}{A numeric vector of length 2. Represents the
desired min and max vertex sizes relative to the x-axis in terms of percentage
(see details).}

\item{adjust}{Numeric scalar. Adjustment made to the resulting adjusted size
(see details).}
}
\value{
An integer vector of the same length as \code{vertex.size} with
rescaled values.
}
\description{
This function rescales a vertex size before passing it to
\code{\link[igraph:plot.igraph]{plot.igraph}} so that the resulting vertices
have the desired size relative to the x-axis.
}
\details{
\code{minmax.relative.size} limits the minimum and maximum size that a vertex
can take in the plot relative to the x-axis scale. The values for the x-axis
scale are by default retrieved by accessing to \code{par("usr")}. By default
the vertex are rescaled to be at least 1\% of the size of the plotting region
and no more than 5\% of the plotting region, \code{minmax.relative.size=c(.01, .05)}.

The default value for \code{adjust} is taken from \code{\link[igraph:igraph]{igraph}}
version 1.0.1. In particular, the function \code{igraph:::.igraph.shape.circle.plot},
in which before passing the \code{vertex.size} to the function
\code{\link[graphics:symbols]{symbols}}, the vertex size is reduced by 200.

The rescaling is as follows:
\deqn{%
 v' = \frac{v - \underbar v}{\bar v - \underbar v}\times (\bar s - \underbar s) + \underbar s
}{%
 v' = (v - v_min)/(v_max - v_min) * (s_max - s_min) + s_min
}

Where \eqn{v} is the vertex size, \eqn{\bar v}{v_max} and \eqn{\underbar v}{v_min} are
the max and min values of \eqn{v} respectively, and \eqn{\bar s}{s_max} and
\eqn{\underbar s}{s_min} are the max and min size that vertices take in terms
of \code{minmax.relative.size} and \code{par.usr}. The adjusted value \eqn{v'}
is then multiplied by \code{adjust}.

\code{igraph_vertex_rescale} and \code{vertex_rescale_igraph} are aliases.
}
\examples{

library(igraph)

# Random graph and coordinates
set.seed(2134)
g <- barabasi.game(10)
coords <- layout_nicely(g)

# Random size and figures
size <- runif(10)
size <- cbind(size, size)
shap <- sample(c("circle", "square"),10,TRUE)

# Plotting
oldpar <- par(no.readonly = TRUE)
par(mfrow=c(2,2), mai=rep(.5,4))
for (i in seq(1, 1000, length.out = 4)) {
  # New plot-window
  plot.new()
  plot.window(xlim=range(coords[,1]*i), ylim=range(coords[,2]*i))

  # plotting graph
  plot(g, layout=coords*i, add=TRUE, rescale=FALSE,
       vertex.shape = shap,
       vertex.size  = rescale_vertex_igraph(size) # HERE WE RESCALE!
  )

  # Adding some axis
  axis(1, lwd=0, lwd.ticks = 1)
  axis(2, lwd=0, lwd.ticks = 1)
  box()
}

par(oldpar)

}
\seealso{
Other visualizations: 
\code{\link{dgr}()},
\code{\link{diffusionMap}()},
\code{\link{drawColorKey}()},
\code{\link{grid_distribution}()},
\code{\link{hazard_rate}()},
\code{\link{plot_adopters}()},
\code{\link{plot_diffnet2}()},
\code{\link{plot_diffnet}()},
\code{\link{plot_infectsuscep}()},
\code{\link{plot_threshold}()}
}
\author{
George G. Vega Yon
}
\concept{visualizations}
