% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ego_variance}
\alias{ego_variance}
\title{Computes variance of \eqn{Y} at ego level}
\usage{
ego_variance(graph, Y, funname, all = FALSE)
}
\arguments{
\item{graph}{A matrix of size \eqn{n\times n}{n*n} of class \code{dgCMatrix}.}

\item{Y}{A numeric vector of length \eqn{n}.}

\item{funname}{Character scalar. Comparison to make (see \code{\link{vertex_covariate_compare}}).}

\item{all}{Logical scalar. When \code{FALSE} (default) \eqn{f_i} is mean at
ego level. Otherwise is fix for all i (see details).}
}
\value{
A numeric vector of length \eqn{n}.
}
\description{
Computes variance of \eqn{Y} at ego level
}
\details{
For each vertex \eqn{i} the variance is computed as follows

\deqn{%
(\sum_j a_{ij})^{-1}\sum_j a_{ij} \left[f(y_i,y_j) - f_i\right]^2
}{%
(sum_j a(ij))^(-1) * \sum_j a(ij) * [f(y(i),y(j)) - f(i)]^2
}

Where \eqn{a_{ij}}{a(ij)} is the ij-th element of \code{graph}, \eqn{f} is
the function specified in \code{funname}, and, if \code{all=FALSE}
\eqn{f_i = \sum_j a_{ij}f(y_i,y_j)^2/\sum_ja_{ij}}{f(i)=\sum_j a(ij)f(y(i), y(j))^2/\sum_j a(ij)},
otherwise \eqn{f_i = f_j = \frac{1}{n^2}\sum_{i,j}f(y_i,y_j)}{f(i)=f(j)=(1/n^2)\sum_(i,j) f(y_i,y_j)}


This is an auxiliary function for \code{\link{struct_test}}. The idea is
to compute an adjusted measure of disimilarity between vertices, so the
closest in terms of \eqn{f} is \eqn{i} to its neighbors, the smaller the
relative variance.
}
\seealso{
\code{\link{struct_test}}

Other statistics: 
\code{\link{bass}},
\code{\link{classify_adopters}()},
\code{\link{cumulative_adopt_count}()},
\code{\link{dgr}()},
\code{\link{exposure}()},
\code{\link{hazard_rate}()},
\code{\link{infection}()},
\code{\link{moran}()},
\code{\link{struct_equiv}()},
\code{\link{threshold}()},
\code{\link{vertex_covariate_dist}()}
}
\concept{statistics}
