% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.r
\name{igraph}
\alias{igraph}
\alias{diffnet_to_igraph}
\alias{igraph_to_diffnet}
\title{Coercion between graph classes}
\usage{
diffnet_to_igraph(graph, slices = 1:nslices(graph))

igraph_to_diffnet(graph = NULL, graph.list = NULL, toavar, t0 = NULL,
  t1 = NULL, ...)
}
\arguments{
\item{graph}{Either a \code{\link{diffnet}} or \code{\link[igraph:igraph]{igraph}} graph object.}

\item{slices}{An integer vector indicating the slices to subset.}

\item{graph.list}{A list of \code{igraph} objects.}

\item{toavar}{Character scalar. Name of the attribute that holds the times of adoption.}

\item{t0}{Integer scalar. Passed to \code{\link[=diffnet-class]{new_diffnet}}.}

\item{t1}{Integer scalar. Passed to \code{\link[=diffnet-class]{new_diffnet}}.}

\item{...}{Further arguments passed to \code{\link{as_diffnet}}.}
}
\value{
Either a list of \code{length(slices)} \code{igraph}
(\code{diffnet_to_igraph}), or a \code{diffnet} object (\code{igraph_to_diffnet})
objects.
}
\description{
Coercion between graph classes
}
\examples{
# Reading the meddical innovation data into igraph --------------------------
x <- diffnet_to_igraph(medInnovationsDiffNet)

# Fetching the times of adoption
igraph::vertex_attr(x[[1]], "toa")
}
\seealso{
Other Foreign: \code{\link{network}},
  \code{\link{read_pajek}}, \code{\link{read_ucinet_head}}
}
