% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{plot.diffnet}
\alias{plot.diffnet}
\title{S3 plotting method for diffnet objects.}
\usage{
\method{plot}{diffnet}(x, y = NULL, t = 1, displaylabels = FALSE,
  vertex.col = c(adopt = "blue", noadopt = "grey"),
  gmode = ifelse(x$meta$undirected, "graph", "digraph"),
  vertex.cex = "degree", edge.col = "gray", mode = "fruchtermanreingold",
  layout.par = NULL, main = "Diffusion network in time \%d", ...)
}
\arguments{
\item{x}{An object of class \code{\link[=diffnet-class]{diffnet}}}

\item{y}{Ignored.}

\item{t}{Integer scalar indicating the time slice to plot.}

\item{displaylabels}{Logical scalar. When TRUE, \code{plot} shows vertex labels.}

\item{vertex.col}{Character scalar/vector. Color of the vertices.}

\item{gmode}{Character scalar. Passed to \code{\link[sna:gplot]{sna::gplot}.}}

\item{vertex.cex}{Numeric scalar/vector. Size of the vertices.}

\item{edge.col}{Character scalar/vector. Color of the edges.}

\item{mode}{Character scalar. In the case of \code{plot}, passed to
\code{\link[sna:gplot]{gplot}}.}

\item{layout.par}{Layout parameters (see details).}

\item{main}{Character. A title template to be passed to sprintf.}

\item{...}{Further arguments passed to \code{\link[sna:gplot]{gplot}}.}
}
\value{
A matrix with the coordinates of the vertices.
}
\description{
S3 plotting method for diffnet objects.
}
\details{
Plotting is done via the function \code{\link[sna:gplot]{gplot}},
and its layout via \code{\link[sna:gplot.layout]{gplot.layout}}, both from
the (\pkg{sna}) package.

\code{vertex.cex} can either be a numeric scalar, a numeric vector or a character
scalar taking any of the following values \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}. The later will be passed to \code{\link{dgr}} to calculate
degree of the selected slice and will be normalized as

\deqn{
  vertex.cex = d/[max(d) - min(d)]\times 2 + .5}{%
  vertex.cex = d/[max(d) - min(d)]* 2 + .5 %
 }

where \code{d=sqrt(dgr(graph))}.
}
\examples{

data(medInnovationsDiffNet)
plot(medInnovationsDiffNet)


}
\seealso{
Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet-class}}, \code{\link{diffnet_index}},
  \code{\link{summary.diffnet}}
}
\author{
George G. Vega Yon
}
