% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-class.R, R/diffnet-methods.R
\name{as_diffnet}
\alias{[.diffnet}
\alias{as_diffnet}
\alias{diffnet}
\alias{diffnet-class}
\alias{diffnet.attrs}
\alias{diffnet.attrs<-}
\alias{diffnet.subset.slices}
\alias{diffnet.toa}
\alias{diffnet.toa<-}
\alias{plot.diffnet}
\alias{print.diffnet}
\alias{summary.diffnet}
\title{Creates a \code{diffnet} class object}
\usage{
as_diffnet(graph, toa, t0 = min(toa, na.rm = TRUE), t1 = max(toa, na.rm =
  TRUE), vertex.dyn.attrs = NULL, vertex.static.attrs = NULL,
  graph.attrs = NULL, undirected = getOption("diffnet.undirected"),
  self = getOption("diffnet.self"),
  multiple = getOption("diffnet.multiple"))

diffnet.subset.slices(graph, slices)

diffnet.attrs(graph, element = c("vertex", "graph"), attr.class = c("dyn",
  "static"), as.df = FALSE)

diffnet.attrs(graph, element = "vertex", attr.class = "static") <- value

diffnet.toa(graph)

diffnet.toa(graph, i) <- value

\method{plot}{diffnet}(x, y = NULL, t = 1, displaylabels = FALSE,
  vertex.col = c("blue", "grey"), gmode = ifelse(x$meta$undirected, "graph",
  "digraph"), vertex.cex = "degree", edge.col = "gray",
  mode = "fruchtermanreingold", layout.par = NULL,
  main = "Diffusion network in time \%d", ...)

\method{print}{diffnet}(x, ...)

\method{summary}{diffnet}(object, slices = NULL, no.print = FALSE,
  skip.moran = FALSE, valued = getOption("diffnet.valued", FALSE), ...)

\method{[}{diffnet}(x, i, j, drop = FALSE)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{toa}{Numeric vector of size \eqn{n}. Times of adoption.}

\item{t0}{Integer scalar. Passed to \code{\link{toa_mat}}.}

\item{t1}{Integer scalar. Passed to \code{\link{toa_mat}}.}

\item{vertex.dyn.attrs}{List of length \eqn{T}. Contains matrices with vertex attributes.}

\item{vertex.static.attrs}{Numeric matrix with \eqn{n} rows.}

\item{graph.attrs}{Numeric matrix with a single row.}

\item{undirected}{Logical scalar.}

\item{self}{Logical scalar.}

\item{multiple}{Logical scalar.}

\item{slices}{Integer vector.}

\item{element}{Character vector/scalar. Indicates what to retrieve/alter.}

\item{attr.class}{Character vector/scalar. Indicates the class of the attribute, either dynamic (\code{"dyn"}),
or static (\code{"static"}).}

\item{as.df}{Logical scalar. When TRUE returns a data.frame.}

\item{value}{In the case of \code{diffnet.toa}, replacement, otherwise see below.}

\item{i}{Indices specifying elements to replace. See \code{\link[base:Extract]{Extract}}.}

\item{x}{A \code{diffnet} object.}

\item{y}{Ignored.}

\item{t}{Integer scalar indicating the time slice to plot.}

\item{displaylabels}{Logical scalar. When TRUE, \code{plot} shows vertex labels.}

\item{vertex.col}{Character scalar/vector. Color of the vertices.}

\item{gmode}{Character scalar. Passed to \code{\link[sna:gplot]{gplot}.}}

\item{vertex.cex}{Numeric scalar/vector. Size of the vertices.}

\item{edge.col}{Character scalar/vector. Color of the edges.}

\item{mode}{Character scalar. Name of the layout algorithm to implement (see details).}

\item{layout.par}{Layout parameters (see details).}

\item{main}{Character. A title template to be passed to sprintf.}

\item{...}{In the case of \code{plot}, further arguments passed to \code{gplot}, otherwise
is ignored.}

\item{object}{A \code{diffnet} object.}

\item{no.print}{Logical scalar. When TRUE suppress screen messages.}

\item{skip.moran}{Logical scalar. When TRUE Moran's I is not reported (see details).}

\item{valued}{Logical scalar. When FALSE non-zero values in the adjmat are set to one.}

\item{j}{Ignored.}

\item{drop}{Ignored}
}
\value{
A list of class \code{diffnet} with the following elements:
\item{graph}{A list of length \eqn{T}. Containing sparse square matrices of size \eqn{n}
and class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}.}
\item{toa}{An integer vector of size \eqn{T} with times of adoption.}
\item{adopt, cumadopt}{Numeric matrices of size \eqn{n\times T}{n*T} as those returned
by \code{\link{toa_mat}}.}
\item{vertex.static.attrs}{If not NULL, a matrix with \eqn{n} rows with vertex static
attributes.}
\item{vertex.dyn.attrs}{A list of length \eqn{T} with matrices containing vertex attributes
throught time (dynamic).}
\item{graph.attrs}{If not NULL, a numeric matrix with 1 row containing graph attributes.}
\item{meta}{A list of length 9 with the following elements:
\itemize{
 \item \code{type}: Character scalar equal to \code{"dynamic"}.
 \item \code{class}: Character scalar equal to \code{"list"}.
 \item \code{ids}: Character vector of size \eqn{n} with vertices' labels.
 \item \code{pers}: Integer vector of size \eqn{T}.
 \item \code{nper}: Integer scalar equal to \eqn{T}.
 \item \code{n}: Integer scalar equal to \eqn{n}.
 \item \code{self}: Logical scalar.
 \item \code{undirected}: Logical scalar.
 \item \code{multiple}: Logical scalar.
}
}
}
\description{
\code{diffnet} objects contain difussion of innovation networks. With adjacency
matrices and time of adoption (toa) vector as its main components, most of the
package's functions have methods for this class of objects.
}
\details{
Plotting is done via the function \code{\link[sna:gplot]{gplot}},
and its layout via \code{\link[sna:gplot.layout]{gplot.layout}}, both from
the (\pkg{sna}) package.

\code{vertex.cex} can either be a numeric scalar, a numeric vector or a character
scalar taking any of the following values \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}. The later will be passed to \code{\link{dgr}} to calculate
degree of the selected slice and will be normalized as

\deqn{vertex.cex = d/[max(d) - min(d)]\times 2 + .5}{vertex.cex = d/[max(d) - min(d)]* 2 + .5}

where \code{d=sqrt(dgr(graph))}.

In the case of the \code{summary} method, Moran's I is calculated over the
cumulative adoption matrix using as weighting matrix the inverse of the geodesic
distance matrix. All this via \code{\link{moran}}. For each time period \code{t},
this is calculated as:

\preformatted{
 m = moran(C[,t], G^(-1))
}

Where \code{C[,t]} is the t-th column of the cumulative adoption matrix,
\code{G^(-1)} is the element-wise inverse of the geodesic matrix at time \code{t},
and \code{moran} is \pkg{netdiffuseR}'s moran's I routine. When \code{skip.moran=TRUE}
Moran's I is not reported. This can be useful when the graph is particuarly
large (tens of thousands of vertices) as when doing so geodesic distances are
not calculated, which avoids allocating a square matrix of size \eqn{n} on
the memory. As a difference from the adjacency matrices, the matrix with the
geodesic distances can't be stored as a sparse matrix (saving space).
}
\section{Auxiliary functions}{


\code{diffnet.subset.slices} retrieves a subsection, in terms of time periods,
of the graph. When doing so, it modifies the \code{toa} vector as well as the
\code{adopt} and \code{cumadopt} matrices collapsing network tinmming. For example,
if a network goes from time 1 to 20 and we set \code{slices=3:10}, all individuals
who adopted prior to time 3 will be set as adopters at time 3, and all individuals
who adopted after time 10 will be set as adopters at time 10, changing the
adoption and cumulative adoption matrices. Importantly, \code{slice} must be an
integer range without gaps.

\code{diffnet.attrs} Allows retriving network attributes. In particular, by default
returns a list of length \eqn{T} with matrices with the following columns:

\enumerate{
 \item \code{per} Indicating the time period to which the observation corresponds.
 \item \code{toa} Indicating the time of adoption of the vertex.
 \item Further columns depending on the vertex and graph attributes.
}

Each vertex static attributes' are repeated \eqn{T} times in total so that these
can be binded (\code{rbind}) to dynamic attributes.

When \code{as.df=TRUE}, this convenience function is useful as it can be used
to create event history (panel data) datasets used for model fitting.

Conversely, the replacement method allows including new vertex or graph
attributes either dynamic or static (see examples below).

\code{diffnet.toa(graph)} works as an alias of \code{graph$toa}.
The replacement method, \code{diffnet.toa<-} used as \code{diffnet.toa(graph)<-...},
is the right way of modifying times of adoption as when doing so it
 performs several checks on the time ranges, and
recalculates adoption and cumulative adoption matrices using \code{toa_mat}.
}
\examples{

# Creating a random graph
set.seed(123)
graph <- rgraph_ba(t=9)
graph <- lapply(1:5, function(x) graph)

# Pretty TOA
names(graph) <- 2001L:2005L
toa <- sample(c(2001L:2005L,NA), 10, TRUE)

# Creating diffnet object
diffnet <- as_diffnet(graph, toa)
diffnet
summary(diffnet)

# ATTRIBUTES ----------------------------------------------------------------

# Adding new attributes to the network
diffnet.attrs(diffnet, "vertex", "static") <- cbind(posnum=1:diffnet$meta$n)
diffnet.attrs(diffnet, "vertex", "dyn") <-
 lapply(1:diffnet$meta$nper, function(x) cbind(rand=runif(diffnet$meta$n)))

# Retrieving attributes
diffnet.attrs(diffnet, "vertex", "static")

# Now as a data.frame (only static)
diffnet.attrs(diffnet, "vertex", "static", as.df = TRUE)

# Now as a data.frame (all of them)
diffnet.attrs(diffnet, as.df = TRUE)

}
\author{
Vega Yon
}
\seealso{
Default options are listed at \code{\link{netdiffuseR-options}}
}

