% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.nested_model_fit}
\alias{tidy.nested_model_fit}
\alias{glance.nested_model_fit}
\alias{glance_nested}
\title{Turn a nested model into a tidy tibble}
\usage{
\method{tidy}{nested_model_fit}(x, ...)

\method{glance}{nested_model_fit}(x, ...)

glance_nested(x, ...)
}
\arguments{
\item{x}{A \code{nested_model_fit} object produced by \code{\link[=fit.nested_model]{fit.nested_model()}}.}

\item{...}{Additional arguments passed into their respective functions.
(e.g. for \code{tidy.nested_model_fit()}, \code{\link[parsnip:tidy.model_fit]{parsnip::tidy.model_fit()}}).}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}. With \code{glance.nested_model_fit()}, the
tibble will have 1 row.
}
\description{
Use broom functions on fitted nested models.

\code{tidy.nested_model_fit()} summarises components of each model within a
nested model fit, indicating which nested data frame each row corresponds
to.

\code{glance.nested_model_fit()} summarises a nested model, returning a
\code{\link[tibble:tibble]{tibble::tibble()}} with 1 row.

\code{glance_nested()} summarises each model within a nested model fit,
returning a \code{\link[tibble:tibble]{tibble::tibble()}} with the same number of rows as the number
of inner models.
}
\details{
\code{\link[generics:glance]{generics::glance()}} states that \code{glance()} methods should always return 1
row outputs for non-empty inputs. The 'nestedmodels' package is no
exception: \code{glance()} methods will combine rows to produce a result with a
single row. Specifically:
\itemize{
\item If a column contains 1 unique value, that value is used.
\item If a column is numeric, the mean will be calculated.
\item Otherwise, the results will be combined into a list.
}
}
\examples{
\dontshow{if (rlang::is_installed("broom")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)
library(parsnip)
library(broom)

data <- filter(example_nested_data, id \%in\% 1:5)

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

fit <- fit(
  model, z ~ x + y + a + b,
  group_by(data, id)
)

tidy(fit)
glance(fit)
glance_nested(fit)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}} \code{\link[generics:glance]{generics::glance()}}
}
