% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit.nested_model}
\alias{fit.nested_model}
\title{Fit a nested model to a dataset}
\usage{
\method{fit}{nested_model}(
  object,
  formula,
  data,
  case_weights = NULL,
  control = parsnip::control_parsnip(),
  ...
)
}
\arguments{
\item{object}{An \code{nested_model} object (see \code{\link[=nested]{nested()}}).}

\item{formula}{An object of class \code{formula}. Passed into
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}}. This should \emph{not contain} the variable to
nest by.}

\item{data}{A data frame. If used with a 'nested_model' object, the data
frame must already be nested.}

\item{case_weights}{An optional vector of case weights. Passed into
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}}.}

\item{control}{A \code{\link[parsnip:control_parsnip]{parsnip::control_parsnip()}} object. Passed into
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}}.}

\item{...}{Passed into \code{\link[parsnip:fit]{parsnip::fit.model_spec()}}. Currently unused.}
}
\value{
A \code{nested_model_fit} object with several elements:
\itemize{
\item \code{spec}: The model specification object (the inner model of the
nested model object)
\item \code{fit}: A tibble containing the model fits and the nests that they
correspond to.
\item \code{inner_names}: A character vector of names, used to help with
nesting the data during predictions.
}
}
\description{
\code{fit.model_spec()} takes a nested model specification and fits the inner
model specification to each nested data frame in the given dataset.
}
\examples{

library(parsnip)
library(tidyr)

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

nested_data <- nest(example_nested_data, data = -id)

fit(model, z ~ x + y + a + b, nested_data)

}
\seealso{
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}} \link[parsnip:model_fit]{parsnip::model_fit}
}
