% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innercv_roc.R
\name{innercv_summary}
\alias{innercv_summary}
\title{Summarise performance on inner CV test folds}
\usage{
innercv_summary(x)
}
\arguments{
\item{x}{a \code{nestcv.glmnet} or \code{nestcv.train} object}
}
\value{
Returns performance metrics from outer training folds, see
\link{predSummary}.
}
\description{
Calculates performance metrics on inner CV held-out test folds: confusion
matrix, accuracy and balanced accuracy for classification; ROC AUC for binary
classification; RMSE, R^2 and mean absolute error (MAE) for regression.
}
\examples{
data(iris)
x <- iris[, 1:4]
y <- iris[, 5]

fit <- nestcv.glmnet(y, x,
                     family = "multinomial",
                     alpha = 1,
                     n_outer_folds = 3)
summary(fit)
innercv_summary(fit)

}
\seealso{
\link{predSummary}
}
